/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.menus.setup.actions;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.inventory.AInventory;
import io.github.InsiderAnh.xPlayerKits.inventory.InventorySizes;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.libs.nbtapi.NBTItem;
import io.github.InsiderAnh.xPlayerKits.libs.xseries.XMaterial;
import io.github.InsiderAnh.xPlayerKits.menus.setup.KitEditorMenu;
import io.github.InsiderAnh.xPlayerKits.menus.setup.actions.KitActionsMenu;
import io.github.InsiderAnh.xPlayerKits.menus.setup.requirements.KitRequirementsMenu;
import io.github.InsiderAnh.xPlayerKits.utils.ItemUtils;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class KitMainActionsMenu
extends AInventory {
    private final PlayerKits playerKits = PlayerKits.getInstance();
    private final Kit kit;

    public KitMainActionsMenu(Player player, Kit kit) {
        super(player, InventorySizes.GENERIC_9X4, PlayerKits.getInstance().getLang().getString("menus.mainActions.title"));
        this.kit = kit;
    }

    @Override
    protected void onClick(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
        Player player = this.getPlayer();
        NBTItem nbtItem = new NBTItem(currentItem);
        if (nbtItem.hasTag("action")) {
            switch (nbtItem.getString("action")) {
                case "claimCommands": {
                    new KitActionsMenu(player, this.kit, "claim").open();
                    return;
                }
                case "denyCommands": {
                    new KitActionsMenu(player, this.kit, "deny").open();
                    return;
                }
                case "requirements": {
                    new KitRequirementsMenu(player, this.kit).open();
                    return;
                }
                case "back": {
                    new KitEditorMenu(player, this.kit).open();
                    return;
                }
                case "close": {
                    this.close();
                    return;
                }
            }
        }
    }

    @Override
    protected void onUpdate(Inventory inventory) {
        ItemStack requirements = new ItemUtils(XMaterial.BOOK.get()).displayName(this.playerKits.getLang().getString("menus.mainActions.requirements.nameItem")).lore(this.playerKits.getLang().getString("menus.mainActions.requirements.loreItem").replace("<requirements>", this.kit.getRequirementsString())).build();
        ItemStack claimCommands = new ItemUtils(XMaterial.GOLD_INGOT.get()).displayName(this.playerKits.getLang().getString("menus.mainActions.claimCommands.nameItem")).lore(this.playerKits.getLang().getString("menus.mainActions.claimCommands.loreItem").replace("<claimCommands>", this.kit.getActionsOnClaimString())).build();
        ItemStack denyCommands = new ItemUtils(XMaterial.REDSTONE.get()).displayName(this.playerKits.getLang().getString("menus.mainActions.denyCommands.nameItem")).lore(this.playerKits.getLang().getString("menus.mainActions.denyCommands.loreItem").replace("<denyCommands>", this.kit.getActionsOnDenyString())).build();
        ItemStack back = new ItemUtils(XMaterial.ARROW.get()).displayName(this.playerKits.getLang().getString("menus.mainKitEditor.back.nameItem")).build();
        ItemStack close = new ItemUtils(XMaterial.BARRIER.get()).displayName(this.playerKits.getLang().getString("menus.mainKitEditor.close.nameItem")).build();
        inventory.setItem(11, XPKUtils.applySimpleTag(requirements, "action", "requirements"));
        inventory.setItem(13, XPKUtils.applySimpleTag(claimCommands, "action", "claimCommands"));
        inventory.setItem(15, XPKUtils.applySimpleTag(denyCommands, "action", "denyCommands"));
        inventory.setItem(27, XPKUtils.applySimpleTag(back, "action", "back"));
        inventory.setItem(31, XPKUtils.applySimpleTag(close, "action", "close"));
    }
}

