/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.menus.setup.requirements;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.inventory.AInventory;
import io.github.InsiderAnh.xPlayerKits.inventory.InventorySizes;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.libs.anvilgui.AnvilGUI;
import io.github.InsiderAnh.xPlayerKits.libs.nbtapi.NBTItem;
import io.github.InsiderAnh.xPlayerKits.libs.xseries.XMaterial;
import io.github.InsiderAnh.xPlayerKits.libs.xseries.XSound;
import io.github.InsiderAnh.xPlayerKits.menus.setup.actions.KitMainActionsMenu;
import io.github.InsiderAnh.xPlayerKits.utils.ItemUtils;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class KitRequirementsMenu
extends AInventory {
    private final PlayerKits playerKits = PlayerKits.getInstance();
    private final Kit kit;

    public KitRequirementsMenu(Player player, Kit kit) {
        super(player, InventorySizes.GENERIC_9X6, PlayerKits.getInstance().getLang().getString("menus.requirements.title"));
        this.kit = kit;
    }

    @Override
    protected void onClick(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
        Player player = this.getPlayer();
        NBTItem nbtItem = new NBTItem(currentItem);
        if (nbtItem.hasTag("requirementIndex")) {
            int requirementIndex = nbtItem.getInteger("requirementIndex");
            ArrayList<String> requirements = this.kit.getRequirements();
            if (requirementIndex >= 0 && requirementIndex < requirements.size()) {
                if (click == ClickType.LEFT) {
                    String requirement = requirements.get(requirementIndex);
                    player.sendMessage(this.playerKits.getLang().getString("messages.requirementInfo").replace("<requirement>", requirement));
                    player.playSound(player.getLocation(), (Sound)XSound.BLOCK_NOTE_BLOCK_PLING.get(), 1.0f, 1.0f);
                } else if (click == ClickType.RIGHT) {
                    requirements.remove(requirementIndex);
                    if (requirements.isEmpty()) {
                        requirements.add("none");
                    }
                    player.sendMessage(this.playerKits.getLang().getString("messages.requirementRemoved"));
                    player.playSound(player.getLocation(), (Sound)XSound.ENTITY_ITEM_BREAK.get(), 1.0f, 1.0f);
                    this.onUpdate(this.getInventory());
                } else if (click == ClickType.SHIFT_LEFT) {
                    if (requirementIndex > 0) {
                        String temp = requirements.get(requirementIndex);
                        requirements.set(requirementIndex, requirements.get(requirementIndex - 1));
                        requirements.set(requirementIndex - 1, temp);
                        player.playSound(player.getLocation(), (Sound)XSound.ENTITY_EXPERIENCE_ORB_PICKUP.get(), 1.0f, 1.0f);
                        this.onUpdate(this.getInventory());
                    }
                } else if (click == ClickType.SHIFT_RIGHT && requirementIndex < requirements.size() - 1) {
                    String temp = requirements.get(requirementIndex);
                    requirements.set(requirementIndex, requirements.get(requirementIndex + 1));
                    requirements.set(requirementIndex + 1, temp);
                    player.playSound(player.getLocation(), (Sound)XSound.ENTITY_EXPERIENCE_ORB_PICKUP.get(), 1.0f, 1.0f);
                    this.onUpdate(this.getInventory());
                }
            }
            return;
        }
        if (nbtItem.hasTag("action")) {
            String action;
            switch (action = nbtItem.getString("action")) {
                case "newRequirement": {
                    this.openRequirementInput(player);
                    return;
                }
                case "clearAll": {
                    this.kit.getRequirements().clear();
                    this.kit.getRequirements().add("none");
                    player.sendMessage(this.playerKits.getLang().getString("messages.requirementsCleared"));
                    player.playSound(player.getLocation(), (Sound)XSound.ENTITY_GENERIC_EXPLODE.get(), 1.0f, 1.0f);
                    this.onUpdate(this.getInventory());
                    return;
                }
                case "back": {
                    new KitMainActionsMenu(player, this.kit).open();
                    return;
                }
                case "close": {
                    this.close();
                    return;
                }
            }
        }
    }

    private void openRequirementInput(Player player) {
        String title = this.playerKits.getLang().getString("menus.requirements.input.title");
        String defaultText = "%player_name% == Steve";
        new AnvilGUI.Builder().plugin((Plugin)this.playerKits).title(XPKUtils.color(title)).text(defaultText).onClick((index, completion) -> {
            String input = completion.getText();
            String[] parts = input.split(" ");
            if (parts.length < 3) {
                player.sendMessage(this.playerKits.getLang().getString("messages.invalidRequirementFormat"));
                player.playSound(player.getLocation(), (Sound)XSound.ENTITY_VILLAGER_NO.get(), 1.0f, 1.0f);
                return Collections.singletonList(AnvilGUI.ResponseAction.close());
            }
            ArrayList<String> requirements = this.kit.getRequirements();
            if (requirements.size() == 1 && requirements.get(0).equalsIgnoreCase("none")) {
                requirements.clear();
            }
            requirements.add(input);
            player.sendMessage(this.playerKits.getLang().getString("messages.requirementAdded"));
            player.playSound(player.getLocation(), (Sound)XSound.ENTITY_PLAYER_LEVELUP.get(), 1.0f, 1.0f);
            new KitRequirementsMenu(player, this.kit).open();
            return Collections.singletonList(AnvilGUI.ResponseAction.close());
        }).open(player);
    }

    @Override
    protected void onUpdate(Inventory inventory) {
        inventory.clear();
        ArrayList<String> requirements = this.kit.getRequirements();
        Player player = this.getPlayer();
        AtomicInteger index = new AtomicInteger();
        for (int i = 0; i < requirements.size(); ++i) {
            String status;
            Material material;
            String requirement = requirements.get(i);
            if (requirement.equalsIgnoreCase("none")) {
                material = Material.GRAY_DYE;
                status = "&7No requirement";
            } else {
                boolean passes = XPKUtils.passCondition(player, requirement);
                material = passes ? Material.LIME_DYE : Material.RED_DYE;
                status = passes ? "&aPass \u2713" : "&cFail \u2717";
                String[] parts = requirement.split(" ");
                if (parts.length >= 1) {
                    String placeholder = parts[0];
                    String resolved = PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder);
                    status = status + "\n&7Preview: &f" + resolved;
                }
            }
            ItemStack itemStack = new ItemUtils(material).displayName(this.playerKits.getLang().getString("menus.requirements.requirement.nameItem").replace("<index>", String.valueOf(i + 1)).replace("<status>", status)).lore(this.playerKits.getLang().getString("menus.requirements.requirement.loreItem").replace("<requirement>", requirement).replace("<status>", status)).build();
            int slot = XPKUtils.SLOTS[index.getAndIncrement()];
            if (slot >= 45) continue;
            inventory.setItem(slot, XPKUtils.applySimpleTag(itemStack, "requirementIndex", i));
        }
        ItemStack back = new ItemUtils(XMaterial.ARROW.get()).displayName(this.playerKits.getLang().getString("menus.mainKitEditor.back.nameItem")).build();
        ItemStack close = new ItemUtils(XMaterial.BARRIER.get()).displayName(this.playerKits.getLang().getString("menus.mainKitEditor.close.nameItem")).build();
        ItemStack newRequirement = new ItemUtils(XMaterial.EMERALD.get()).displayName(this.playerKits.getLang().getString("menus.requirements.newRequirement.nameItem")).lore(this.playerKits.getLang().getString("menus.requirements.newRequirement.loreItem")).build();
        ItemStack clearAll = new ItemUtils(XMaterial.TNT.get()).displayName(this.playerKits.getLang().getString("menus.requirements.clearAll.nameItem")).lore(this.playerKits.getLang().getString("menus.requirements.clearAll.loreItem")).build();
        inventory.setItem(45, XPKUtils.applySimpleTag(back, "action", "back"));
        inventory.setItem(49, XPKUtils.applySimpleTag(close, "action", "close"));
        inventory.setItem(52, XPKUtils.applySimpleTag(clearAll, "action", "clearAll"));
        inventory.setItem(53, XPKUtils.applySimpleTag(newRequirement, "action", "newRequirement"));
    }
}

