/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.nms.v1_17_R1;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.InsiderAnh.xPlayerKits.api.PlayerKitsNMS;
import io.github.InsiderAnh.xPlayerKits.items.versions.CrossVersionPotionEffect;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class PlayerKitsNMS_v1_17_R1
extends PlayerKitsNMS {
    private final Gson GSON = new Gson();

    @Override
    public void deserializePotionMeta(PotionMeta potionMeta, Map<String, Object> data) {
        String potionDataStr;
        String[] parts;
        if (data.containsKey("potion_data") && (parts = (potionDataStr = (String)data.get("potion_data")).split(":")).length >= 3) {
            PotionType type = PotionType.valueOf((String)parts[0]);
            boolean extended = Boolean.parseBoolean(parts[1]);
            boolean upgraded = Boolean.parseBoolean(parts[2]);
            potionMeta.setBasePotionData(new PotionData(type, extended, upgraded));
        }
        if (!data.containsKey("potion_effects")) {
            return;
        }
        List effectList = (List)data.get("potion_effects");
        for (Object effectObj : effectList) {
            PotionEffect effect = this.parsePotionEffect(effectObj.toString());
            if (effect == null) continue;
            potionMeta.addCustomEffect(effect, true);
        }
    }

    private PotionEffect parsePotionEffect(String effectStr) {
        String[] parts = effectStr.split(":");
        if (parts.length < 3) {
            return null;
        }
        PotionEffectType type = CrossVersionPotionEffect.getEffect(parts[0]);
        if (type == null) {
            return null;
        }
        try {
            int amplifier = Integer.parseInt(parts[1]) - 1;
            int duration = Integer.parseInt(parts[2]);
            return new PotionEffect(type, duration, amplifier);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void serializePotionMeta(ItemStack itemStack, YamlConfiguration config, String path) {
        PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
        if (potionMeta == null) {
            return;
        }
        PotionData potionData = potionMeta.getBasePotionData();
        if (potionData != null) {
            config.set(path + ".potion_data", (Object)(potionData.getType().name().toLowerCase() + ":" + potionData.isExtended() + ":" + potionData.isUpgraded()));
        }
        if (!potionMeta.hasCustomEffects()) {
            return;
        }
        ArrayList<String> effects = new ArrayList<String>();
        for (PotionEffect effect : potionMeta.getCustomEffects()) {
            String effectId = CrossVersionPotionEffect.getEffectId(effect.getType());
            effects.add(effectId + ":" + (effect.getAmplifier() + 1) + ":" + effect.getDuration());
        }
        config.set(path + ".potion_effects", effects);
    }

    @Override
    public void sendTitle(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }

    @Override
    public void playSound(Location location, String sound, float volume, float pitch) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        location.getWorld().playSound(location, sound, volume, pitch);
    }

    @Override
    public void sendActionBar(Player player, String message) {
        player.sendActionBar((Component)Component.text(message));
    }

    @Override
    public void sendMiniMessage(Player player, String message) {
    }

    @Override
    public void setUnbreakable(ItemMeta itemMeta, boolean unbreakable) {
        if (itemMeta == null) {
            return;
        }
        itemMeta.setUnbreakable(unbreakable);
    }

    @Override
    public boolean isUnbreakable(ItemMeta itemMeta) {
        return itemMeta.isUnbreakable();
    }

    @Override
    public int getCustomModelData(ItemMeta itemMeta) {
        return itemMeta.getCustomModelData();
    }

    @Override
    public void setCustomModelData(ItemMeta itemMeta, int customModelData) {
        if (itemMeta == null) {
            return;
        }
        itemMeta.setCustomModelData(Integer.valueOf(customModelData));
    }

    @Override
    public void setGlowing(ItemMeta itemMeta, boolean glowing) {
        if (itemMeta == null) {
            return;
        }
        itemMeta.addEnchant(Enchantment.ARROW_INFINITE, 1, true);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
    }

    @Override
    public ItemStack value(ItemStack itemStack, String value) {
        if (value.isEmpty()) {
            return itemStack;
        }
        if (value.startsWith("https://textures.minecraft.net/texture/")) {
            return this.texture(itemStack, value);
        }
        SkullMeta headMeta = (SkullMeta)itemStack.getItemMeta();
        PlayerProfile profile = this.getPlayerProfile(value);
        headMeta.setPlayerProfile(profile);
        itemStack.setItemMeta((ItemMeta)headMeta);
        return itemStack;
    }

    @Override
    public ItemStack texture(ItemStack itemStack, String texture) {
        if (texture.isEmpty()) {
            return itemStack;
        }
        if (!texture.startsWith("https://textures.minecraft.net/texture/")) {
            texture = "https://textures.minecraft.net/texture/" + texture;
        }
        SkullMeta headMeta = (SkullMeta)itemStack.getItemMeta();
        PlayerProfile playerProfile = Bukkit.createProfile((UUID)UUID.randomUUID());
        itemStack.setItemMeta((ItemMeta)headMeta);
        return itemStack;
    }

    private PlayerProfile getPlayerProfile(String base64Url) {
        return null;
    }

    public String decodeSkinUrl(String base64Texture) {
        String cleanBase64Texture = this.fixBase64Padding(base64Texture);
        try {
            String decoded = new String(Base64.getDecoder().decode(cleanBase64Texture));
            JsonElement root = (JsonElement)this.GSON.fromJson(decoded, JsonElement.class);
            if (!root.isJsonObject()) {
                System.out.println("decodeSkinUrl: decoded value is not a JSON object: " + decoded);
                return null;
            }
            JsonObject object = root.getAsJsonObject();
            JsonObject textures = object.getAsJsonObject("textures");
            if (textures == null) {
                return null;
            }
            JsonObject skin = textures.getAsJsonObject("SKIN");
            if (skin == null) {
                return null;
            }
            JsonElement url = skin.get("url");
            return url != null ? url.getAsString() : null;
        }
        catch (Exception e) {
            Bukkit.getLogger().info("Error: " + cleanBase64Texture + " track " + e.getMessage());
            return null;
        }
    }

    private String fixBase64Padding(String base64) {
        int mod = (base64 = base64.trim().replace("\n", "").replace("\r", "")).length() % 4;
        if (mod != 0) {
            base64 = base64 + this.repeat("=", 4 - mod);
        }
        return base64;
    }

    private String repeat(String str, int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }
}

