/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.placeholders;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.data.KitData;
import io.github.InsiderAnh.xPlayerKits.data.PlayerKitData;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerKitsPlaceholders
extends PlaceholderExpansion {
    private final PlayerKits playerKits = PlayerKits.getInstance();

    @NotNull
    public String getIdentifier() {
        return "xplayerkits";
    }

    @NotNull
    public String getAuthor() {
        return "InsiderAnh";
    }

    @NotNull
    public String getVersion() {
        return "1.0.0";
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String placeholder) {
        PlayerKitData playerKitData = this.playerKits.getDatabase().getCachedPlayerData(player.getUniqueId());
        if (placeholder.startsWith("cooldown_")) {
            return this.parseCountdown(this.getKitFromPlaceholder(placeholder, "cooldown_"), playerKitData);
        }
        if (placeholder.startsWith("claimed_onetime_")) {
            return this.parseClaimed(this.getKitFromPlaceholder(placeholder, "claimed_onetime_"), playerKitData);
        }
        if (placeholder.startsWith("claimed_cooldown_")) {
            return this.parseCooldown(this.getKitFromPlaceholder(placeholder, "claimed_cooldown_"), playerKitData);
        }
        return null;
    }

    private String parseCountdown(Kit kit, PlayerKitData playerKitData) {
        if (kit == null) {
            return "No such kit";
        }
        KitData kitData = playerKitData.getKitsData().get(kit.getName());
        if (kitData == null || kitData.getCountdown() <= System.currentTimeMillis()) {
            return this.playerKits.getLang().getString("countdown.noCountdown");
        }
        long remaining = kitData.getCountdown() - System.currentTimeMillis();
        return XPKUtils.millisToLongDHMS(remaining);
    }

    private String parseClaimed(Kit kit, PlayerKitData playerKitData) {
        if (kit == null) {
            return "No such kit";
        }
        KitData kitData = playerKitData.getKitsData().get(kit.getName());
        return kitData != null && kitData.isBought() ? "yes" : "no";
    }

    private String parseCooldown(Kit kit, PlayerKitData playerKitData) {
        if (kit == null) {
            return "No such kit";
        }
        KitData kitData = playerKitData.getKitsData().get(kit.getName());
        return kitData != null && kitData.getCountdown() > System.currentTimeMillis() ? "yes" : "no";
    }

    private Kit getKitFromPlaceholder(String placeholder, String prefix) {
        String kitName = placeholder.substring(prefix.length());
        return this.playerKits.getKitManager().getKit(kitName);
    }
}

