/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.utils;

import com.google.gson.Gson;
import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.api.events.ClaimXKitEvent;
import io.github.InsiderAnh.xPlayerKits.commands.XKitsCommands;
import io.github.InsiderAnh.xPlayerKits.data.KitData;
import io.github.InsiderAnh.xPlayerKits.data.PlayerKitData;
import io.github.InsiderAnh.xPlayerKits.enums.MinecraftVersion;
import io.github.InsiderAnh.xPlayerKits.executions.Execution;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.kits.properties.PropertyTiming;
import io.github.InsiderAnh.xPlayerKits.libs.nbtapi.NBTItem;
import io.github.InsiderAnh.xPlayerKits.libs.xseries.XSound;
import io.github.InsiderAnh.xPlayerKits.placeholders.Placeholder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public final class XPKUtils {
    public static final MinecraftVersion SERVER_VERSION;
    public static final int[] SLOTS;
    private static final PlayerKits playerKits;
    private static final Gson gson;
    private static final Pattern pattern;

    public static void claimKit(Player player, Kit kit, PlayerKitData playerKitData) {
        if (kit.isNoHasRequirements(player)) {
            player.sendMessage(playerKits.getLang().getString("messages.noRequirements"));
            player.playSound(player.getLocation(), (Sound)XSound.ENTITY_ENDERMAN_TELEPORT.get(), 1.0f, 1.0f);
            return;
        }
        if (!kit.getPermission().equals("none") && !player.hasPermission(kit.getPermission())) {
            XPKUtils.executeActions(player, kit.getActionsOnDeny());
            player.sendMessage(playerKits.getLang().getString("messages.noPermissionKit"));
            player.playSound(player.getLocation(), (Sound)XSound.ENTITY_ENDERMAN_TELEPORT.get(), 1.0f, 1.0f);
            return;
        }
        KitData kitData = playerKitData.getKitsData().get(kit.getName());
        PropertyTiming timing = kit.getPropertyTiming();
        if (timing.isOneTime() && kitData != null && kitData.isOneTime() && !player.hasPermission("xkits.onetime.bypass")) {
            XPKUtils.executeActions(player, kit.getActionsOnDeny());
            player.sendMessage(playerKits.getLang().getString("messages.alreadyOneTime"));
            player.playSound(player.getLocation(), (Sound)XSound.ENTITY_ENDERMAN_TELEPORT.get(), 1.0f, 1.0f);
            return;
        }
        if (kitData != null && kitData.getCountdown() > System.currentTimeMillis() && !player.hasPermission("xkits.countdown.bypass")) {
            XPKUtils.executeActions(player, kit.getActionsOnDeny());
            player.sendMessage(playerKits.getLang().getString("messages.waitCountdown").replace("<time>", XPKUtils.millisToLongDHMS(kitData.getCountdown() - System.currentTimeMillis())));
            player.playSound(player.getLocation(), (Sound)XSound.ENTITY_ENDERMAN_TELEPORT.get(), 1.0f, 1.0f);
            return;
        }
        if (kit.getPropertyInventory().isCheckInventorySpace() && kit.isNoInventorySpace(player)) {
            XPKUtils.executeActions(player, kit.getActionsOnDeny());
            player.sendMessage(playerKits.getLang().getString("messages.noInventorySpace"));
            player.playSound(player.getLocation(), (Sound)XSound.ENTITY_ENDERMAN_TELEPORT.get(), 1.0f, 1.0f);
            return;
        }
        ClaimXKitEvent event = new ClaimXKitEvent(player, kit);
        playerKits.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        playerKitData.getKitsData().put(kit.getName(), new KitData(kit.getName(), System.currentTimeMillis() + timing.getCountdown() * 1000L, timing.isOneTime(), false));
        playerKits.getExecutor().execute(() -> {
            playerKits.getDatabase().updatePlayerData(player.getUniqueId());
            playerKits.getStellarTaskHook(() -> kit.giveKit(player)).runTask(player.getLocation());
        });
    }

    public static String getStatus(boolean bool) {
        return PlayerKits.getInstance().getLang().getString("messages." + (bool ? "enabled" : "disabled"));
    }

    @Deprecated
    public static String color(String message) {
        return PlayerKits.getInstance().getColorUtils().translateAlternateColorCodes('&', message);
    }

    @Deprecated
    public static String translateAlternateColorCodes(char altColorChar, String message) {
        if (SERVER_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_16)) {
            Matcher matcher = pattern.matcher(message);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String color = message.substring(matcher.start(), matcher.end());
                try {
                    ChatColor chatColor = ChatColor.of((String)color);
                    matcher.appendReplacement(stringBuffer, chatColor.toString());
                }
                catch (Exception exception) {}
            }
            matcher.appendTail(stringBuffer);
            message = stringBuffer.toString();
        }
        return ChatColor.translateAlternateColorCodes((char)altColorChar, (String)message);
    }

    public static ItemStack applySimpleTag(ItemStack item, String key, String value) {
        NBTItem nbtItem = new NBTItem(item);
        nbtItem.setString(key, value);
        nbtItem.mergeNBT(item);
        return item;
    }

    public static ItemStack applySimpleTag(ItemStack item, String key, int value) {
        NBTItem nbtItem = new NBTItem(item);
        nbtItem.setInteger(key, value);
        nbtItem.mergeNBT(item);
        return item;
    }

    public static boolean isHelmet(String material) {
        return material.endsWith("_HELMET") || material.equals("PLAYER_HEAD") || material.equals("SKULL_ITEM");
    }

    public static boolean isChestplate(String material) {
        return material.endsWith("_CHESTPLATE") || material.equals("ELYTRA");
    }

    public static boolean isLeggings(String material) {
        return material.endsWith("_LEGGINGS");
    }

    public static boolean isBoots(String material) {
        return material.endsWith("_BOOTS");
    }

    public static void executeActions(Player player, List<Execution> listToExecute) {
        PlayerKits.getInstance().getExecutionManager().execute(player, listToExecute, new Placeholder("<player>", player.getName()));
    }

    public static boolean passCondition(Player player, String condition) {
        String[] sep = condition.split(" ");
        String variable = PlaceholderAPI.setPlaceholders((Player)player, (String)sep[0]);
        String conditional = sep[1];
        try {
            switch (conditional) {
                case "==": {
                    return variable.equals(sep[2]);
                }
                case "!=": {
                    return !variable.equals(sep[2]);
                }
                case ">=": 
                case "<=": 
                case ">": 
                case "<": {
                    double valueFinal = Double.parseDouble(sep[2]);
                    double valueFinalVariable = Double.parseDouble(variable);
                    switch (conditional) {
                        case ">=": {
                            return valueFinalVariable >= valueFinal;
                        }
                        case "<=": {
                            return valueFinalVariable <= valueFinal;
                        }
                        case ">": {
                            return valueFinalVariable > valueFinal;
                        }
                        case "<": {
                            return valueFinalVariable < valueFinal;
                        }
                    }
                    return false;
                }
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            return false;
        }
    }

    public static String millisToLongDHMS(long millis) {
        StringBuilder time = new StringBuilder();
        boolean space = false;
        if (millis >= 1000L) {
            long l = millis / 86400000L;
            if (l > 0L) {
                space = true;
                millis -= l * 86400000L;
                time.append(l).append("d");
            }
            if (space) {
                time.append(" ");
                space = false;
            }
            if ((l = millis / 3600000L) > 0L) {
                space = true;
                millis -= l * 3600000L;
                time.append(l).append("h");
            }
            if (space) {
                time.append(" ");
                space = false;
            }
            if ((l = millis / 60000L) > 0L) {
                space = true;
                millis -= l * 60000L;
                time.append(l).append("m");
            }
            if ((l = millis / 1000L) > 0L) {
                if (space) {
                    time.append(" ");
                }
                time.append(l).append(l > 1L ? "s" : "");
            }
            return time.toString();
        }
        return "0";
    }

    public static ItemStack parseIcon(String path, YamlConfiguration configuration) {
        ItemStack itemStack = XPKUtils.parseItemStack(path, configuration);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemStack.setAmount(configuration.getInt(path + ".amount"));
        if (configuration.getInt(path + ".custom-model-data") != 0) {
            playerKits.getPlayerKitsNMS().setCustomModelData(itemMeta, configuration.getInt(path + ".custom-model-data"));
        }
        if (configuration.getBoolean(path + ".glowing")) {
            playerKits.getPlayerKitsNMS().setGlowing(itemMeta, true);
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack parseItemStack(String path, YamlConfiguration configuration) {
        String type = configuration.getString(path + ".material");
        if (type.startsWith("head:") || type.startsWith("player_head:")) {
            return new ItemStack(Material.STONE);
        }
        return new ItemStack(Material.valueOf((String)type));
    }

    public static ItemStack parseItemStack(Player player, String material, int amount, short data) {
        if (material.startsWith("head:") || material.startsWith("player_head:")) {
            if (player == null) {
                return new ItemStack(Material.STONE);
            }
            ItemStack head = new ItemStack(Material.PLAYER_HEAD);
            String name = material.replaceFirst("player_head:", "").replace("%player_name%", player.getName());
            if (name.startsWith("http://textures.minecraft.net/texture/")) {
                playerKits.getPlayerKitsNMS().texture(head, name);
                return head;
            }
            if (name.length() > 16) {
                playerKits.getPlayerKitsNMS().value(head, name);
                return head;
            }
            SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
            skullMeta.setOwner(material.replaceFirst("player_head:", "").replace("%player_name%", player.getName()));
            head.setItemMeta((ItemMeta)skullMeta);
            return head;
        }
        return new ItemStack(Material.valueOf((String)material), amount, data);
    }

    public static void registerCommandDynamic(String command, XKitsCommands cmd) {
        try {
            Constructor constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            constructor.setAccessible(true);
            PluginCommand pluginCommand = (PluginCommand)constructor.newInstance(new Object[]{command, playerKits});
            pluginCommand.setExecutor((CommandExecutor)cmd);
            pluginCommand.setTabCompleter((TabCompleter)cmd);
            Field commandMapField = playerKits.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(playerKits.getServer());
            commandMap.register(command, (Command)pluginCommand);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Generated
    private XPKUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static Gson getGson() {
        return gson;
    }

    @Generated
    public static Pattern getPattern() {
        return pattern;
    }

    static {
        SLOTS = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
        playerKits = PlayerKits.getInstance();
        pattern = Pattern.compile("#[a-fA-F0-9]{6}");
        gson = new Gson();
        String cbPackage = Bukkit.getServer().getClass().getPackage().getName();
        String detectedVersion = cbPackage.substring(cbPackage.lastIndexOf(46) + 1);
        if (!detectedVersion.startsWith("v")) {
            detectedVersion = Bukkit.getServer().getBukkitVersion();
        }
        SERVER_VERSION = MinecraftVersion.get(detectedVersion);
    }
}

