/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.bcc;

import com.google.gson.Gson;
import com.mojang.logging.LogUtils;
import dev.wuffs.bcc.Config;
import dev.wuffs.bcc.Metadata;
import dev.wuffs.bcc.data.BetterStatus;
import dev.wuffs.bcc.data.BetterStatusServerHolder;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.CrashReportCallables;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;

@Mod(value="bcc")
public class BetterCompatibilityChecker {
    public static final String MODID = "bcc";
    private static final Logger LOGGER = LogUtils.getLogger();

    public BetterCompatibilityChecker(IEventBus modEventBus, ModContainer modContainer) {
        LOGGER.info("Better Compatibility Checker starting");
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.CONFIG);
        modEventBus.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Better Compatibility Checker setup");
        if (((Boolean)Config.useMetadata.get()).booleanValue()) {
            Path metaFile = FMLPaths.CONFIGDIR.get().resolve("metadata.json");
            if (!Files.exists(metaFile, new LinkOption[0])) {
                LOGGER.error("No metadata.json found, falling back to config values");
            } else {
                try {
                    LOGGER.info("Loading metadata.json");
                    Metadata metadata = (Metadata)new Gson().fromJson((Reader)Files.newBufferedReader(metaFile), Metadata.class);
                    LOGGER.info("Loaded metadata.json - Modpack: {} | Version: {}", (Object)metadata.name, (Object)metadata.version.name);
                    BetterStatusServerHolder.INSTANCE.setStatus(new BetterStatus(metadata.name, metadata.version.name, true));
                    return;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to read metadata.json", (Throwable)e);
                }
            }
        }
        BetterStatusServerHolder.INSTANCE.setStatus(new BetterStatus((String)Config.modpackName.get(), (String)Config.modpackVersion.get(), false));
        BetterStatus status = BetterStatusServerHolder.INSTANCE.getStatus();
        LOGGER.info("Loaded BetterCompatibilityChecker - Modpack: {} | Version: {}", (Object)status.name(), (Object)status.version());
        CrashReportCallables.registerCrashCallable((String)"BetterCompatibilityChecker", () -> "Modpack Name: " + status.name() + " | Modpack Version: " + status.version());
    }

    public static boolean comparePingData(BetterStatus pingData) {
        BetterStatus status = BetterStatusServerHolder.INSTANCE.getStatus();
        return pingData.name().equals(status.name()) && pingData.version().equals(status.version());
    }
}

