/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfRect;
import org.opencv.core.Scalar;
import org.opencv.objdetect.Dictionary;
import org.opencv.utils.Converters;

public class Objdetect {
    public static final int CASCADE_DO_CANNY_PRUNING = 1;
    public static final int CASCADE_SCALE_IMAGE = 2;
    public static final int CASCADE_FIND_BIGGEST_OBJECT = 4;
    public static final int CASCADE_DO_ROUGH_SEARCH = 8;
    public static final int DetectionBasedTracker_DETECTED_NOT_SHOWN_YET = 0;
    public static final int DetectionBasedTracker_DETECTED = 1;
    public static final int DetectionBasedTracker_DETECTED_TEMPORARY_LOST = 2;
    public static final int DetectionBasedTracker_WRONG_OBJECT = 3;
    public static final int CORNER_REFINE_NONE = 0;
    public static final int CORNER_REFINE_SUBPIX = 1;
    public static final int CORNER_REFINE_CONTOUR = 2;
    public static final int CORNER_REFINE_APRILTAG = 3;
    public static final int DICT_4X4_50 = 0;
    public static final int DICT_4X4_100 = 1;
    public static final int DICT_4X4_250 = 2;
    public static final int DICT_4X4_1000 = 3;
    public static final int DICT_5X5_50 = 4;
    public static final int DICT_5X5_100 = 5;
    public static final int DICT_5X5_250 = 6;
    public static final int DICT_5X5_1000 = 7;
    public static final int DICT_6X6_50 = 8;
    public static final int DICT_6X6_100 = 9;
    public static final int DICT_6X6_250 = 10;
    public static final int DICT_6X6_1000 = 11;
    public static final int DICT_7X7_50 = 12;
    public static final int DICT_7X7_100 = 13;
    public static final int DICT_7X7_250 = 14;
    public static final int DICT_7X7_1000 = 15;
    public static final int DICT_ARUCO_ORIGINAL = 16;
    public static final int DICT_APRILTAG_16h5 = 17;
    public static final int DICT_APRILTAG_25h9 = 18;
    public static final int DICT_APRILTAG_36h10 = 19;
    public static final int DICT_APRILTAG_36h11 = 20;
    public static final int DICT_ARUCO_MIP_36h12 = 21;

    public static void groupRectangles(MatOfRect rectList, MatOfInt weights, int groupThreshold, double eps) {
        MatOfRect rectList_mat = rectList;
        MatOfInt weights_mat = weights;
        Objdetect.groupRectangles_0(rectList_mat.nativeObj, weights_mat.nativeObj, groupThreshold, eps);
    }

    public static void groupRectangles(MatOfRect rectList, MatOfInt weights, int groupThreshold) {
        MatOfRect rectList_mat = rectList;
        MatOfInt weights_mat = weights;
        Objdetect.groupRectangles_1(rectList_mat.nativeObj, weights_mat.nativeObj, groupThreshold);
    }

    public static void drawDetectedMarkers(Mat image, List<Mat> corners, Mat ids, Scalar borderColor) {
        Mat corners_mat = Converters.vector_Mat_to_Mat(corners);
        Objdetect.drawDetectedMarkers_0(image.nativeObj, corners_mat.nativeObj, ids.nativeObj, borderColor.val[0], borderColor.val[1], borderColor.val[2], borderColor.val[3]);
    }

    public static void drawDetectedMarkers(Mat image, List<Mat> corners, Mat ids) {
        Mat corners_mat = Converters.vector_Mat_to_Mat(corners);
        Objdetect.drawDetectedMarkers_1(image.nativeObj, corners_mat.nativeObj, ids.nativeObj);
    }

    public static void drawDetectedMarkers(Mat image, List<Mat> corners) {
        Mat corners_mat = Converters.vector_Mat_to_Mat(corners);
        Objdetect.drawDetectedMarkers_2(image.nativeObj, corners_mat.nativeObj);
    }

    public static void generateImageMarker(Dictionary dictionary, int id, int sidePixels, Mat img, int borderBits) {
        Objdetect.generateImageMarker_0(dictionary.nativeObj, id, sidePixels, img.nativeObj, borderBits);
    }

    public static void generateImageMarker(Dictionary dictionary, int id, int sidePixels, Mat img) {
        Objdetect.generateImageMarker_1(dictionary.nativeObj, id, sidePixels, img.nativeObj);
    }

    public static Dictionary getPredefinedDictionary(int dict) {
        return new Dictionary(Objdetect.getPredefinedDictionary_0(dict));
    }

    public static Dictionary extendDictionary(int nMarkers, int markerSize, Dictionary baseDictionary, int randomSeed) {
        return new Dictionary(Objdetect.extendDictionary_0(nMarkers, markerSize, baseDictionary.nativeObj, randomSeed));
    }

    public static Dictionary extendDictionary(int nMarkers, int markerSize, Dictionary baseDictionary) {
        return new Dictionary(Objdetect.extendDictionary_1(nMarkers, markerSize, baseDictionary.nativeObj));
    }

    public static Dictionary extendDictionary(int nMarkers, int markerSize) {
        return new Dictionary(Objdetect.extendDictionary_2(nMarkers, markerSize));
    }

    public static void drawDetectedCornersCharuco(Mat image, Mat charucoCorners, Mat charucoIds, Scalar cornerColor) {
        Objdetect.drawDetectedCornersCharuco_0(image.nativeObj, charucoCorners.nativeObj, charucoIds.nativeObj, cornerColor.val[0], cornerColor.val[1], cornerColor.val[2], cornerColor.val[3]);
    }

    public static void drawDetectedCornersCharuco(Mat image, Mat charucoCorners, Mat charucoIds) {
        Objdetect.drawDetectedCornersCharuco_1(image.nativeObj, charucoCorners.nativeObj, charucoIds.nativeObj);
    }

    public static void drawDetectedCornersCharuco(Mat image, Mat charucoCorners) {
        Objdetect.drawDetectedCornersCharuco_2(image.nativeObj, charucoCorners.nativeObj);
    }

    public static void drawDetectedDiamonds(Mat image, List<Mat> diamondCorners, Mat diamondIds, Scalar borderColor) {
        Mat diamondCorners_mat = Converters.vector_Mat_to_Mat(diamondCorners);
        Objdetect.drawDetectedDiamonds_0(image.nativeObj, diamondCorners_mat.nativeObj, diamondIds.nativeObj, borderColor.val[0], borderColor.val[1], borderColor.val[2], borderColor.val[3]);
    }

    public static void drawDetectedDiamonds(Mat image, List<Mat> diamondCorners, Mat diamondIds) {
        Mat diamondCorners_mat = Converters.vector_Mat_to_Mat(diamondCorners);
        Objdetect.drawDetectedDiamonds_1(image.nativeObj, diamondCorners_mat.nativeObj, diamondIds.nativeObj);
    }

    public static void drawDetectedDiamonds(Mat image, List<Mat> diamondCorners) {
        Mat diamondCorners_mat = Converters.vector_Mat_to_Mat(diamondCorners);
        Objdetect.drawDetectedDiamonds_2(image.nativeObj, diamondCorners_mat.nativeObj);
    }

    private static native void groupRectangles_0(long var0, long var2, int var4, double var5);

    private static native void groupRectangles_1(long var0, long var2, int var4);

    private static native void drawDetectedMarkers_0(long var0, long var2, long var4, double var6, double var8, double var10, double var12);

    private static native void drawDetectedMarkers_1(long var0, long var2, long var4);

    private static native void drawDetectedMarkers_2(long var0, long var2);

    private static native void generateImageMarker_0(long var0, int var2, int var3, long var4, int var6);

    private static native void generateImageMarker_1(long var0, int var2, int var3, long var4);

    private static native long getPredefinedDictionary_0(int var0);

    private static native long extendDictionary_0(int var0, int var1, long var2, int var4);

    private static native long extendDictionary_1(int var0, int var1, long var2);

    private static native long extendDictionary_2(int var0, int var1);

    private static native void drawDetectedCornersCharuco_0(long var0, long var2, long var4, double var6, double var8, double var10, double var12);

    private static native void drawDetectedCornersCharuco_1(long var0, long var2, long var4);

    private static native void drawDetectedCornersCharuco_2(long var0, long var2);

    private static native void drawDetectedDiamonds_0(long var0, long var2, long var4, double var6, double var8, double var10, double var12);

    private static native void drawDetectedDiamonds_1(long var0, long var2, long var4);

    private static native void drawDetectedDiamonds_2(long var0, long var2);
}

