/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.util.UndashedUuid;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import ru.dimaskama.webcam.WebcamMod;
import ru.dimaskama.webcam.net.KnownSource;

public class KnownSourceClient {
    private final UUID uuid;
    private final String name;
    @Nullable
    private final NativeImage customIcon;
    @Nullable
    private ResourceLocation customIconId;
    private String nameForSearch;

    public KnownSourceClient(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
        this.customIcon = null;
    }

    public KnownSourceClient(KnownSource source) {
        this.uuid = source.getUuid();
        this.name = source.getName();
        byte[] customIconPixels = source.getCustomIcon();
        NativeImage customIcon = null;
        if (customIconPixels != null) {
            customIcon = new NativeImage(16, 16, false);
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    int i = (y * 16 + x) * 4;
                    customIcon.setPixelABGR(x, y, (customIconPixels[i] & 0xFF) << 24 | (customIconPixels[i + 1] & 0xFF) << 16 | (customIconPixels[i + 2] & 0xFF) << 8 | customIconPixels[i + 3] & 0xFF);
                }
            }
        }
        this.customIcon = customIcon;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public ResourceLocation getCustomIcon() {
        if (this.customIcon != null && this.customIconId == null) {
            ResourceLocation id = WebcamMod.id("custom_icon_" + UndashedUuid.toString((UUID)this.uuid));
            Minecraft.getInstance().getTextureManager().register(id, (AbstractTexture)new DynamicTexture(() -> ((ResourceLocation)id).getPath(), this.customIcon));
            this.customIconId = id;
        }
        return this.customIconId;
    }

    public String getNameForSearch() {
        if (this.nameForSearch == null) {
            this.nameForSearch = this.name.toLowerCase(Locale.ROOT);
        }
        return this.nameForSearch;
    }

    public void close() {
        if (this.customIcon != null) {
            Minecraft.getInstance().execute(() -> {
                if (this.customIconId != null) {
                    Minecraft.getInstance().getTextureManager().release(this.customIconId);
                } else {
                    this.customIcon.close();
                }
            });
        }
    }
}

