/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.cap;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.chat.Component;
import org.lwjgl.system.MemoryUtil;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.videoio.VideoCapture;
import ru.dimaskama.webcam.client.cap.DeviceException;
import ru.dimaskama.webcam.client.config.Resolution;

public class CapturingDevice
extends Thread {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final int deviceNumber;
    private final FrameConsumer frameConsumer;
    private final Mat tempMat;
    private final Mat tempMat2;
    private volatile Resolution resolution;
    private volatile int fps;
    private volatile int squareDimension;
    private volatile Throwable error;

    public CapturingDevice(int deviceNumber, FrameConsumer frameConsumer) {
        this.deviceNumber = deviceNumber;
        this.frameConsumer = frameConsumer;
        this.tempMat = new Mat();
        this.tempMat2 = new Mat();
        this.setDaemon(true);
        this.setName("CapturingDevice" + deviceNumber);
        this.setUncaughtExceptionHandler((t, e) -> {
            this.error = e;
        });
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }

    public void setFps(int fps) {
        this.fps = fps;
    }

    public void setSquareDimension(int squareDimension) {
        this.squareDimension = squareDimension >> 1 << 1;
    }

    public Throwable getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Resolution lastResolution = null;
        int realWidth = 0;
        int realHeight = 0;
        int lastFps = 0;
        int realFps = 0;
        VideoCapture cap = new VideoCapture(this.deviceNumber);
        Mat mat = new Mat();
        try {
            if (!cap.isOpened()) {
                throw new DeviceException((Component)Component.translatable((String)"webcam.error.device_unavailable", (Object[])new Object[]{this.deviceNumber}));
            }
            while (!this.closed.get()) {
                int fps;
                Resolution resolution = this.resolution;
                if (lastResolution != resolution) {
                    lastResolution = resolution;
                    cap.set(3, resolution.width);
                    cap.set(4, resolution.height);
                    realWidth = (int)Math.round(cap.get(3));
                    realHeight = (int)Math.round(cap.get(4));
                }
                if (lastFps != (fps = this.fps)) {
                    lastFps = fps;
                    cap.set(5, fps);
                    realFps = (int)Math.round(cap.get(5));
                }
                if (!cap.read(mat)) {
                    throw new DeviceException((Component)Component.translatable((String)"webcam.error.device_disconnected", (Object[])new Object[]{this.deviceNumber}));
                }
                this.onFrame(realFps, realWidth, realHeight, mat);
            }
        }
        finally {
            cap.release();
            mat.release();
        }
    }

    private void onFrame(int fps, int width, int height, Mat frame) {
        int minDim;
        if (width != height) {
            minDim = Math.min(width, height);
            int startX = width - minDim >> 1;
            int startY = height - minDim >> 1;
            frame = new Mat(frame, new Rect(startX, startY, minDim, minDim));
        } else {
            minDim = width;
        }
        int squareDimension = this.squareDimension;
        if (minDim != squareDimension) {
            Imgproc.resize(frame, this.tempMat, new Size(squareDimension, squareDimension));
            frame = this.tempMat;
        }
        Imgproc.cvtColor(frame, this.tempMat2, 2);
        frame = this.tempMat2;
        int rgbaSize = squareDimension * squareDimension * 4;
        byte[] rgba = new byte[rgbaSize];
        MemoryUtil.memByteBuffer((long)frame.dataAddr(), (int)rgbaSize).get(rgba);
        this.frameConsumer.consumeFrame(fps, squareDimension, squareDimension, rgba);
    }

    public boolean close() {
        if (this.closed.compareAndSet(false, true)) {
            this.tempMat.release();
            this.tempMat2.release();
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface FrameConsumer {
        public void consumeFrame(int var1, int var2, int var3, byte[] var4);
    }
}

