/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ru.dimaskama.webcam.client.config.HudSettings;
import ru.dimaskama.webcam.client.config.Resolution;
import ru.dimaskama.webcam.config.JsonConfig;

public record ClientConfig(boolean showWebcams, boolean webcamEnabled, int selectedDevice, Resolution webcamResolution, int webcamFps, boolean showIcons, int maxDevices, int packetBufferSize, int maxBitrate, HudSettings hud) {
    public static final int MIN_FPS = 5;
    public static final int MAX_FPS = 60;
    public static final int MIN_MAX_DEVICES = 1;
    public static final int MAX_MAX_DEVICES = 50;
    public static final int DEFAULT_MAX_DEVICES = 5;
    public static final int MIN_PACKET_BUFFER_SIZE = 1;
    public static final int MAX_PACKET_BUFFER_SIZE = 100;
    public static final int DEFAULT_PACKET_BUFFER_SIZE = 50;
    public static final int MIN_MAX_BITRATE = 10;
    public static final int MAX_MAX_BITRATE = 10000;
    public static final int DEFAULT_MAX_BITRATE = 5000;
    public static final Codec<ClientConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)JsonConfig.defaultedField(Codec.BOOL, "show_webcams", () -> true).forGetter(ClientConfig::showWebcams), (App)JsonConfig.defaultedField(Codec.BOOL, "webcam_enabled", () -> false).forGetter(ClientConfig::webcamEnabled), (App)JsonConfig.defaultedField(Codec.INT, "selected_device", () -> 0).forGetter(ClientConfig::selectedDevice), (App)JsonConfig.defaultedField(Resolution.CODEC, "webcam_resolution", () -> Resolution.R_1280X720).forGetter(ClientConfig::webcamResolution), (App)JsonConfig.defaultedField(Codec.intRange((int)5, (int)60), "webcam_fps", () -> 30).forGetter(ClientConfig::webcamFps), (App)JsonConfig.defaultedField(Codec.BOOL, "show_icons", () -> true).forGetter(ClientConfig::showIcons), (App)JsonConfig.defaultedField(Codec.intRange((int)1, (int)50), "max_devices", () -> 5).forGetter(ClientConfig::maxDevices), (App)JsonConfig.defaultedField(Codec.intRange((int)1, (int)100), "packet_buffer_size", () -> 50).forGetter(ClientConfig::packetBufferSize), (App)JsonConfig.defaultedField(Codec.intRange((int)10, (int)10000), "max_bitrate", () -> 5000).forGetter(ClientConfig::maxBitrate), (App)JsonConfig.defaultedField(HudSettings.CODEC, "hud", HudSettings::new).forGetter(ClientConfig::hud)).apply((Applicative)instance, ClientConfig::new));

    public ClientConfig() {
        this(true, false, 0, Resolution.R_1280X720, 30, true, 5, 50, 5000, new HudSettings());
    }

    public ClientConfig withShowWebcams(boolean showWebcams) {
        return new ClientConfig(showWebcams, this.webcamEnabled, this.selectedDevice, this.webcamResolution, this.webcamFps, this.showIcons, this.maxDevices, this.packetBufferSize, this.maxBitrate, this.hud);
    }

    public ClientConfig withWebcamEnabled(boolean webcamEnabled) {
        return new ClientConfig(this.showWebcams, webcamEnabled, this.selectedDevice, this.webcamResolution, this.webcamFps, this.showIcons, this.maxDevices, this.packetBufferSize, this.maxBitrate, this.hud);
    }
}

