/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.render;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import ru.dimaskama.webcam.Webcam;
import ru.dimaskama.webcam.WebcamMod;
import ru.dimaskama.webcam.client.WebcamModClient;
import ru.dimaskama.webcam.client.cap.Capturing;
import ru.dimaskama.webcam.client.config.ClientConfig;
import ru.dimaskama.webcam.client.net.WebcamClient;

public class WebcamHud {
    private static final ResourceLocation WEBCAM_SPRITE = WebcamMod.id("webcam");
    private static final ResourceLocation WEBCAM_DISABLED_SPRITE = WebcamMod.id("webcam_disabled");
    private static final ResourceLocation WEBCAM_NO_CONNECTION_SPRITE = WebcamMod.id("webcam_no_connection");
    private static final ResourceLocation WEBCAM_CONNECTING_SPRITE = WebcamMod.id("webcam_connecting");

    public static void drawHud(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        ClientConfig config = WebcamModClient.CONFIG.getData();
        if (config.showIcons() && !Webcam.getService().isInReplay()) {
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate(config.hud().iconX() >= 0.0f ? config.hud().iconX() : (float)guiGraphics.guiWidth() + config.hud().iconX() - 16.0f * config.hud().iconScale(), config.hud().iconY() >= 0.0f ? config.hud().iconY() : (float)guiGraphics.guiHeight() + config.hud().iconY() - 16.0f * config.hud().iconScale());
            guiGraphics.pose().scale(config.hud().iconScale());
            WebcamClient client = WebcamClient.getInstance();
            ResourceLocation sprite = client == null ? WEBCAM_NO_CONNECTION_SPRITE : (!client.isAuthenticated() ? WEBCAM_CONNECTING_SPRITE : (client.isListeningFrames() && Capturing.isCapturing(config.selectedDevice()) ? WEBCAM_SPRITE : WEBCAM_DISABLED_SPRITE));
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, 0, 0, 16, 16);
            guiGraphics.pose().popMatrix();
        }
    }
}

