/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2fc;
import ru.dimaskama.webcam.client.DisplayingVideo;
import ru.dimaskama.webcam.client.duck.AvatarRenderStateDuck;
import ru.dimaskama.webcam.client.render.WebcamRenderTypes;
import ru.dimaskama.webcam.client.render.WebcamRenderer;
import ru.dimaskama.webcam.net.VideoSource;

public class WebcamRenderLayer<M extends HumanoidModel<AvatarRenderState>>
extends RenderLayer<AvatarRenderState, M> {
    private final EntityRenderDispatcher entityRenderDispatcher;

    public WebcamRenderLayer(RenderLayerParent<AvatarRenderState, M> renderLayerParent, EntityRenderDispatcher entityRenderDispatcher) {
        super(renderLayerParent);
        this.entityRenderDispatcher = entityRenderDispatcher;
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int light, AvatarRenderState renderState, float limbAngle, float limbDistance) {
        DisplayingVideo.RenderData renderData;
        DisplayingVideo displayingVideo;
        if (!renderState.isInvisible && (displayingVideo = ((AvatarRenderStateDuck)renderState).webcam_getDisplayingVideo()) != null && (renderData = displayingVideo.getRenderData()) != null) {
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            double maxDistance = renderData.source().getMaxDistance();
            if (localPlayer == null || localPlayer.position().distanceToSqr(renderState.x, renderState.y, renderState.z) <= maxDistance * maxDistance) {
                if (renderData.source() instanceof VideoSource.Face) {
                    poseStack.pushPose();
                    HumanoidModel entityModel = (HumanoidModel)this.getParentModel();
                    entityModel.root().translateAndRotate(poseStack);
                    entityModel.getHead().translateAndRotate(poseStack);
                    poseStack.translate(0.0f, -0.25f, -0.26f);
                    submitNodeCollector.submitCustomGeometry(poseStack, WebcamRenderTypes.square(renderData.textureId()), (pose, consumer) -> WebcamRenderer.renderSquare(pose, consumer, 0.25f, 0.25f));
                    poseStack.popPose();
                } else {
                    VideoSource entityModel = renderData.source();
                    if (entityModel instanceof VideoSource.AboveHead) {
                        VideoSource.AboveHead aboveHead = (VideoSource.AboveHead)entityModel;
                        poseStack.pushPose();
                        poseStack.translate(0.0f, -aboveHead.getOffsetY(), 0.0f);
                        Vector2fc rot = aboveHead.getCustomRotation();
                        poseStack.mulPose((Quaternionfc)new Quaternionf().rotationYXZ(((rot != null ? rot.y() : 180.0f + this.entityRenderDispatcher.camera.getYRot()) - renderState.bodyRot) * ((float)Math.PI / 180), (rot != null ? rot.x() : -this.entityRenderDispatcher.camera.getXRot()) * ((float)Math.PI / 180), 0.0f));
                        float halfSize = 0.5f * aboveHead.getSize();
                        WebcamRenderer.render(renderData.textureId(), poseStack, submitNodeCollector, halfSize, halfSize, aboveHead.getShape());
                        poseStack.popPose();
                    }
                }
            }
        }
    }
}

