/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.screen;

import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import ru.dimaskama.webcam.client.KnownSourceClient;
import ru.dimaskama.webcam.client.WebcamModClient;
import ru.dimaskama.webcam.client.screen.WebcamScreen;
import ru.dimaskama.webcam.client.screen.widget.PlayersWebcamsList;

public class PlayersWebcamsScreen
extends Screen {
    private static final int MENU_WIDTH = 160;
    private static final int MENU_HEIGHT = 200;
    private final Screen parent;
    private final boolean shouldPause;
    private int menuX;
    private int menuY;
    private Tab selectedTab = Tab.ALL;
    private Button allTabButton;
    private Button hiddenTabButton;
    private EditBox search;
    private PlayersWebcamsList list;
    private boolean dirty;

    public PlayersWebcamsScreen(Screen parent, boolean shouldPause) {
        super((Component)Component.translatable((String)"webcam.screen.players_webcams"));
        this.parent = parent;
        this.shouldPause = shouldPause;
    }

    protected void init() {
        this.menuX = this.width - 160 >> 1;
        this.menuY = this.height - 200 >> 1;
        int widgetX = this.menuX + 3;
        int widgetWidth = 154;
        int widgetY = this.menuY + 20;
        int tabButtonWidth = (widgetWidth - 2) / Tab.values().length;
        if (this.allTabButton == null) {
            this.allTabButton = Button.builder((Component)Component.translatable((String)"webcam.screen.players_webcams.tab.all"), button -> {
                this.selectedTab = Tab.ALL;
                this.hiddenTabButton.active = true;
                button.active = false;
                this.refreshList();
            }).build();
            this.allTabButton.active = this.selectedTab != Tab.ALL;
        }
        this.allTabButton.setRectangle(tabButtonWidth, 16, widgetX + 1, widgetY);
        this.addRenderableWidget((GuiEventListener)this.allTabButton);
        if (this.hiddenTabButton == null) {
            this.hiddenTabButton = Button.builder((Component)Component.translatable((String)"webcam.screen.players_webcams.tab.hidden"), button -> {
                this.selectedTab = Tab.HIDDEN;
                this.allTabButton.active = true;
                button.active = false;
                this.refreshList();
            }).build();
            this.hiddenTabButton.active = this.selectedTab != Tab.HIDDEN;
        }
        this.hiddenTabButton.setRectangle(tabButtonWidth, 16, widgetX + 1 + tabButtonWidth, widgetY);
        this.addRenderableWidget((GuiEventListener)this.hiddenTabButton);
        widgetY += 17;
        if (this.search == null) {
            this.search = new EditBox(this.font, 0, 0, (Component)Component.empty());
            this.search.setMaxLength(16);
            this.search.setHint((Component)Component.translatable((String)"webcam.screen.players_webcams.search").withStyle(ChatFormatting.DARK_GRAY));
            this.search.setResponder(string -> this.refreshList());
        }
        this.search.setRectangle(widgetWidth - 2, 16, widgetX + 1, widgetY);
        this.addRenderableWidget((GuiEventListener)this.search);
        widgetY += 18;
        if (this.list == null) {
            this.list = new PlayersWebcamsList(this.minecraft, () -> {
                this.dirty = true;
            }, 154);
            this.refreshList();
        }
        this.list.setRectangle(widgetWidth, 200 - (widgetY - this.menuY) - 4, widgetX, widgetY);
        this.addRenderableWidget((GuiEventListener)this.list);
    }

    private void refreshList() {
        String searchText = this.search.getValue().strip().toLowerCase(Locale.ROOT);
        boolean searchEmpty = searchText.isBlank();
        this.list.refresh(searchEmpty ? this.selectedTab.filter : this.selectedTab.filter.and(s -> s.getNameForSearch().contains(searchText)));
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.renderBackground(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, WebcamScreen.BACKGROUND_SPRITE, this.menuX, this.menuY, 160, 200);
        guiGraphics.drawString(this.font, this.title, this.width - this.font.width((FormattedText)this.title) >> 1, this.menuY + 7, -11184811, false);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return this.shouldPause;
    }

    public void removed() {
        if (this.dirty) {
            this.dirty = false;
            WebcamModClient.BLOCKED_SOURCES.save();
        }
    }

    private static enum Tab {
        ALL(s -> true),
        HIDDEN(s -> WebcamModClient.BLOCKED_SOURCES.getData().contains(s.getUuid()));

        private final Predicate<KnownSourceClient> filter;

        private Tab(Predicate<KnownSourceClient> filter) {
            this.filter = filter;
        }
    }
}

