/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.screen.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.PlayerSkin;
import ru.dimaskama.webcam.WebcamMod;
import ru.dimaskama.webcam.client.DisplayingVideoManager;
import ru.dimaskama.webcam.client.KnownSourceClient;
import ru.dimaskama.webcam.client.KnownSourceManager;
import ru.dimaskama.webcam.client.WebcamModClient;
import ru.dimaskama.webcam.client.config.BlockedSources;
import ru.dimaskama.webcam.client.net.WebcamClient;
import ru.dimaskama.webcam.client.screen.widget.HideWebcamButton;
import ru.dimaskama.webcam.net.packet.AddBlockedSourceC2SPacket;
import ru.dimaskama.webcam.net.packet.RemoveBlockedSourceC2SPacket;

public class PlayersWebcamsList
extends ContainerObjectSelectionList<Entry> {
    private final Runnable dirtyAction;
    private final int rowWidth;
    private Predicate<KnownSourceClient> filter;
    private boolean shouldRefresh;

    public PlayersWebcamsList(Minecraft minecraft, Runnable dirtyAction, int rowWidth) {
        super(minecraft, 0, 0, 0, 36);
        this.dirtyAction = dirtyAction;
        this.rowWidth = rowWidth;
    }

    public void refresh(Predicate<KnownSourceClient> filter) {
        this.filter = filter;
        this.shouldRefresh = true;
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        if (this.shouldRefresh) {
            this.shouldRefresh = false;
            this.clearEntries();
            BlockedSources blocked = WebcamModClient.BLOCKED_SOURCES.getData();
            ArrayList allSources = new ArrayList();
            blocked.sources().forEach((uuid, name) -> {
                KnownSourceClient sourceOnServer = KnownSourceManager.INSTANCE.get((UUID)uuid);
                allSources.add(sourceOnServer != null ? sourceOnServer : new KnownSourceClient((UUID)uuid, (String)name));
            });
            KnownSourceManager.INSTANCE.forEach(source -> {
                if (!blocked.contains(source.getUuid())) {
                    allSources.add(source);
                }
            });
            for (KnownSourceClient source2 : allSources) {
                if (!this.filter.test(source2)) continue;
                this.addEntry((AbstractSelectionList.Entry)new Entry(source2, blocked.contains(source2.getUuid())));
            }
        }
        super.renderWidget(guiGraphics, i, j, f);
    }

    public int getRowWidth() {
        return this.rowWidth;
    }

    public class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private static final ResourceLocation UNKNOWN_SPRITE = WebcamMod.id("unknown");
        private final KnownSourceClient source;
        private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
        private final HideWebcamButton hideButton;

        public Entry(KnownSourceClient source, boolean blocked) {
            this.source = source;
            this.hideButton = new HideWebcamButton(blocked, b -> {
                WebcamClient client = WebcamClient.getInstance();
                if (b) {
                    WebcamModClient.BLOCKED_SOURCES.getData().add(source.getUuid(), source.getName());
                    DisplayingVideoManager.INSTANCE.remove(source.getUuid());
                    if (client != null && client.isAuthenticated()) {
                        client.send(new AddBlockedSourceC2SPacket(source.getUuid()));
                    }
                } else {
                    WebcamModClient.BLOCKED_SOURCES.getData().remove(source.getUuid());
                    if (client != null && client.isAuthenticated()) {
                        client.send(new RemoveBlockedSourceC2SPacket(source.getUuid()));
                    }
                }
                if (!PlayersWebcamsList.this.filter.test(source)) {
                    PlayersWebcamsList.this.removeEntry((AbstractSelectionList.Entry)this);
                }
                PlayersWebcamsList.this.dirtyAction.run();
            });
            this.children.add((AbstractWidget)this.hideButton);
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            int x = this.getX() + 2;
            int y = this.getY();
            int entryWidth = this.getWidth();
            int entryHeight = this.getHeight() - 4;
            guiGraphics.fill(x, y, x + entryWidth - 4, y + entryHeight, 0x33000000);
            ResourceLocation customIcon = this.source.getCustomIcon();
            if (customIcon != null) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, customIcon, x, y, 0.0f, 0.0f, 32, 32, 32, 32);
            } else {
                PlayerSkin skin;
                ClientPacketListener connection = Minecraft.getInstance().getConnection();
                PlayerInfo playerInfo = connection != null ? connection.getPlayerInfo(this.source.getUuid()) : null;
                PlayerSkin playerSkin = skin = playerInfo != null ? playerInfo.getSkin() : null;
                if (skin != null) {
                    PlayerFaceRenderer.draw((GuiGraphics)guiGraphics, (PlayerSkin)skin, (int)x, (int)y, (int)32);
                } else {
                    guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, UNKNOWN_SPRITE, x, y, 32, 32);
                }
            }
            guiGraphics.drawString(Minecraft.getInstance().font, this.source.getName(), x + 36, y + 4, -1);
            this.hideButton.setRectangle(20, 20, x + entryWidth - 4 - 22, y + (entryHeight - 20 >> 1));
            this.hideButton.render(guiGraphics, mouseX, mouseY, deltaTicks);
        }

        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }
    }
}

