/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.screen.widget;

import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.network.chat.Component;
import ru.dimaskama.webcam.client.config.Resolution;

public class ResolutionSelectButton
extends AbstractButton {
    private final Consumer<Resolution> updateConsumer;
    private Resolution selected;

    public ResolutionSelectButton(int x, int y, int width, int height, Resolution selected, Consumer<Resolution> updateConsumer) {
        super(x, y, width, height, ResolutionSelectButton.getText(selected));
        this.updateConsumer = updateConsumer;
        this.selected = selected;
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)"webcam.screen.webcam.resolution.tooltip")));
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
        Resolution[] available = Resolution.values();
        int index = 0;
        for (int i = 0; i < available.length; ++i) {
            if (available[i] != this.selected) continue;
            index = (i + 1) % available.length;
        }
        this.selected = available[index];
        this.setMessage(ResolutionSelectButton.getText(this.selected));
        this.updateConsumer.accept(this.selected);
    }

    private static Component getText(Resolution selected) {
        return Component.translatable((String)"webcam.screen.webcam.resolution", (Object[])new Object[]{selected.key + " (" + selected.aspectRatio.key + ")"});
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }
}

