/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.screen.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import ru.dimaskama.webcam.WebcamMod;
import ru.dimaskama.webcam.client.net.WebcamClient;

public class StatusWidget
extends AbstractWidget {
    private static final ResourceLocation FINE_SPRITE = WebcamMod.id("fine");
    private static final ResourceLocation NOT_FINE_SPRITE = WebcamMod.id("not_fine");
    private Status status;

    public StatusWidget(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty());
        this.update();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.update();
        ResourceLocation sprite = this.status.fine ? FINE_SPRITE : NOT_FINE_SPRITE;
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    private void update() {
        Status status;
        WebcamClient client = WebcamClient.getInstance();
        Status status2 = client != null ? (client.isAuthenticated() ? Status.CONNECTED : Status.CONNECTING) : (status = Status.NO_CONNECTION);
        if (this.status != status) {
            this.status = status;
            this.setMessage(status.text);
            this.setTooltip(Tooltip.create((Component)status.text));
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    protected boolean isValidClickButton(MouseButtonInfo mouseButtonInfo) {
        return false;
    }

    private static enum Status {
        NO_CONNECTION((Component)Component.translatable((String)"webcam.screen.webcam.status.no_connection"), false),
        CONNECTING((Component)Component.translatable((String)"webcam.screen.webcam.status.connecting"), false),
        CONNECTED((Component)Component.translatable((String)"webcam.screen.webcam.status.connected"), true);

        private final Component text;
        private final boolean fine;

        private Status(Component text, boolean fine) {
            this.text = text;
            this.fine = fine;
        }
    }
}

