/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.screen.widget;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import ru.dimaskama.webcam.WebcamMod;
import ru.dimaskama.webcam.client.cap.Capturing;

public class UpdateDevicesButton
extends AbstractButton {
    private static final ResourceLocation SPRITE = WebcamMod.id("button/update");
    private static CompletableFuture<Void> updateFuture = CompletableFuture.completedFuture(null);

    public UpdateDevicesButton(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.translatable((String)"webcam.screen.webcam.update_devices"));
        this.updateActive(true);
    }

    public static void updateDevices() {
        updateFuture.join();
        updateFuture = CompletableFuture.runAsync(Capturing::updateDevices, (Executor)Util.backgroundExecutor());
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
        UpdateDevicesButton.updateDevices();
    }

    private void updateActive(boolean updateTooltip) {
        boolean prevActive = this.active;
        this.active = updateFuture.isDone();
        if (updateTooltip || prevActive != this.active) {
            this.setTooltip(this.active ? Tooltip.create((Component)this.getMessage()) : null);
        }
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateActive(false);
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        int spriteX = this.getX() + (this.getWidth() - 16 >> 1);
        int spriteY = this.getY() + (this.getHeight() - 16 >> 1);
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SPRITE, spriteX, spriteY, 16, 16, this.active ? -1 : -8947849);
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int i) {
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }
}

