/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.neoforge;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.slf4j.LoggerFactory;
import ru.dimaskama.webcam.Webcam;
import ru.dimaskama.webcam.WebcamMod;
import ru.dimaskama.webcam.WebcamModService;
import ru.dimaskama.webcam.WebcamService;
import ru.dimaskama.webcam.client.neoforge.WebcamNeoForgeConfigScreenFactory;
import ru.dimaskama.webcam.logger.Slf4jLogger;
import ru.dimaskama.webcam.message.Channel;
import ru.dimaskama.webcam.message.Message;
import ru.dimaskama.webcam.message.ServerMessaging;
import ru.dimaskama.webcam.neoforge.WebcamNeoForgeMessaging;
import ru.dimaskama.webcam.neoforge.WebcamNeoForgePermissions;

@Mod(value="webcam")
public class WebcamNeoForge {
    private static MinecraftServer server;

    public WebcamNeoForge() {
        Webcam.initLogger(new Slf4jLogger(LoggerFactory.getLogger((String)"Webcam")));
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        WebcamMod.init(modContainer.getModInfo().getVersion().toString(), Path.of("./config/webcam/", new String[0]), new WebcamService(this){

            @Override
            public <T extends Message> void registerChannel(Channel<T> channel, @Nullable ServerMessaging.ServerHandler<T> handler) {
                WebcamNeoForgeMessaging.register(channel, handler);
            }

            @Override
            public void sendToPlayer(UUID player, Message message) {
                ServerPlayer serverPlayer;
                MinecraftServer server = WebcamNeoForge.server;
                if (server != null && (serverPlayer = server.getPlayerList().getPlayer(player)) != null) {
                    WebcamNeoForgeMessaging.sendToPlayer(serverPlayer, message);
                }
            }

            @Override
            public void sendSystemMessage(UUID player, String message) {
                MinecraftServer server = WebcamNeoForge.server;
                if (server != null) {
                    server.execute(() -> {
                        ServerPlayer serverPlayer = server.getPlayerList().getPlayer(player);
                        if (serverPlayer != null) {
                            serverPlayer.sendSystemMessage((Component)Component.literal((String)message));
                        }
                    });
                }
            }

            @Override
            public void acceptForNearbyPlayers(UUID playerUuid, double maxDistance, Consumer<Set<UUID>> action) {
                ServerPlayer player;
                MinecraftServer server = WebcamNeoForge.server;
                if (server != null && (player = server.getPlayerList().getPlayer(playerUuid)) != null) {
                    HashSet<UUID> players = new HashSet<UUID>();
                    players.add(player.getUUID());
                    try {
                        ArrayList levelPlayers = new ArrayList(player.level().players());
                        Vec3 pos = player.position();
                        double maxDistanceSqr = maxDistance * maxDistance;
                        for (Player levelPlayer : levelPlayers) {
                            if (!(levelPlayer.position().distanceToSqr(pos) <= maxDistanceSqr)) continue;
                            players.add(levelPlayer.getUUID());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    action.accept(players);
                }
            }

            @Override
            public boolean checkWebcamBroadcastPermission(UUID playerUuid) {
                ServerPlayer player;
                MinecraftServer server = WebcamNeoForge.server;
                if (server != null && (player = server.getPlayerList().getPlayer(playerUuid)) != null) {
                    return WebcamNeoForgePermissions.checkBroadcast(player);
                }
                return true;
            }

            @Override
            public boolean checkWebcamViewPermission(UUID playerUuid) {
                ServerPlayer player;
                MinecraftServer server = WebcamNeoForge.server;
                if (server != null && (player = server.getPlayerList().getPlayer(playerUuid)) != null) {
                    return WebcamNeoForgePermissions.checkView(player);
                }
                return true;
            }

            @Override
            public boolean isInReplay() {
                return false;
            }
        }, new WebcamModService(this){

            @Override
            public boolean isModLoaded(String modId) {
                return ModList.get().isLoaded(modId);
            }

            @Override
            public boolean checkWebcamconfigCommandPermission(CommandSourceStack commandSource) {
                return WebcamNeoForgePermissions.checkWebcamconfigCommand(commandSource);
            }
        });
        if (FMLEnvironment.getDist().isClient()) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)new WebcamNeoForgeConfigScreenFactory());
        }
    }

    static void setServer(MinecraftServer server) {
        WebcamNeoForge.server = server;
    }
}

