/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.neoforge;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import ru.dimaskama.webcam.client.WebcamModClient;
import ru.dimaskama.webcam.message.Channel;
import ru.dimaskama.webcam.message.Message;
import ru.dimaskama.webcam.message.ServerMessaging;

@EventBusSubscriber(modid="webcam")
public class WebcamNeoForgeMessaging {
    private static final List<ChannelToRegister<?>> channelsToRegister = new ArrayList();
    private static final Map<Channel<?>, CustomPacketPayload.Type<MessagePayload>> CHANNEL_TO_PAYLOAD = new HashMap();

    public static <T extends Message> void register(Channel<T> channel, @Nullable ServerMessaging.ServerHandler<T> handler) {
        CHANNEL_TO_PAYLOAD.put(channel, (CustomPacketPayload.Type<MessagePayload>)new CustomPacketPayload.Type(ResourceLocation.parse((String)channel.getId())));
        channelsToRegister.add(new ChannelToRegister<T>(channel, handler));
    }

    @SubscribeEvent
    private static void onRegisterPayloadHandlersEvent(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1").executesOn(HandlerThread.MAIN).optional();
        for (ChannelToRegister<?> channelToRegister : channelsToRegister) {
            WebcamNeoForgeMessaging.registerPayloadChannel(registrar, channelToRegister);
        }
        channelsToRegister.clear();
    }

    private static <T extends Message> void registerPayloadChannel(PayloadRegistrar registrar, ChannelToRegister<T> channelToRegister) {
        Channel channel = channelToRegister.channel;
        ServerMessaging.ServerHandler handler = channelToRegister.handler;
        CustomPacketPayload.Type<MessagePayload> payloadType = WebcamNeoForgeMessaging.getPayloadType(channel);
        StreamCodec streamCodec = StreamCodec.of((buf, payload) -> payload.message.writeBytes((ByteBuf)buf), buf -> new MessagePayload(payloadType, (Message)channel.decode((ByteBuf)buf)));
        if (handler != null) {
            registrar.playToServer(payloadType, streamCodec, (payload, context) -> handler.handle(context.player().getUUID(), context.player().getGameProfile().name(), payload.message));
        } else {
            registrar.playToClient(payloadType, streamCodec, (payload, context) -> WebcamModClient.onMessageReceived(payload.message));
        }
    }

    public static CustomPacketPayload.Type<MessagePayload> getPayloadType(Channel<?> channel) {
        CustomPacketPayload.Type<MessagePayload> payloadType = CHANNEL_TO_PAYLOAD.get(channel);
        if (payloadType == null) {
            throw new IllegalStateException("Channel " + channel.getId() + " is not registered");
        }
        return payloadType;
    }

    public static void sendToPlayer(ServerPlayer player, Message message) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new MessagePayload(WebcamNeoForgeMessaging.getPayloadType(message.getChannel()), message), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private record ChannelToRegister<T extends Message>(Channel<T> channel, @Nullable ServerMessaging.ServerHandler<T> handler) {
    }

    public record MessagePayload(CustomPacketPayload.Type<MessagePayload> type, Message message) implements CustomPacketPayload
    {
    }
}

