/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.neoforge;

import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;

@EventBusSubscriber(modid="webcam")
public class WebcamNeoForgePermissions {
    public static final PermissionNode<Boolean> BROADCAST = new PermissionNode("webcam", "broadcast", PermissionTypes.BOOLEAN, (player, uuid, contexts) -> true, new PermissionDynamicContextKey[0]);
    public static final PermissionNode<Boolean> VIEW = new PermissionNode("webcam", "view", PermissionTypes.BOOLEAN, (player, uuid, contexts) -> true, new PermissionDynamicContextKey[0]);
    public static final PermissionNode<Boolean> WEBCAMCONFIG_COMMAND = new PermissionNode("webcam", "command.config", PermissionTypes.BOOLEAN, (player, uuid, contexts) -> player != null && player.hasPermissions(2), new PermissionDynamicContextKey[0]);

    @SubscribeEvent
    private static void onPermissionGatherNodes(PermissionGatherEvent.Nodes event) {
        event.addNodes(new PermissionNode[]{BROADCAST, VIEW, WEBCAMCONFIG_COMMAND});
    }

    public static boolean checkBroadcast(ServerPlayer player) {
        return (Boolean)PermissionAPI.getPermission((ServerPlayer)player, BROADCAST, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
    }

    public static boolean checkView(ServerPlayer player) {
        return (Boolean)PermissionAPI.getPermission((ServerPlayer)player, VIEW, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
    }

    public static boolean checkWebcamconfigCommand(CommandSourceStack commandSource) {
        ServerPlayer player = commandSource.getPlayer();
        return player != null ? ((Boolean)PermissionAPI.getPermission((ServerPlayer)player, WEBCAMCONFIG_COMMAND, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue() : commandSource.hasPermission(2);
    }
}

