/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.server;

import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import ru.dimaskama.webcam.net.Encryption;

public class PlayerState {
    private final UUID uuid;
    private final String name;
    private final Set<UUID> blockedSources = ConcurrentHashMap.newKeySet();
    private final AtomicBoolean broadcastPermission = new AtomicBoolean(true);
    private final AtomicBoolean viewPermission = new AtomicBoolean(true);
    @Nullable
    private volatile InetSocketAddress socketAddress;
    @Nullable
    private volatile UUID secret;
    @Nullable
    private SecretKey secretKey;
    private volatile boolean authenticated;
    private volatile long lastKeepAlive;
    private volatile boolean showWebcams = true;

    public PlayerState(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setSocketAddress(@Nullable InetSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    @Nullable
    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getSecret() {
        if (this.secret == null) {
            PlayerState playerState = this;
            synchronized (playerState) {
                if (this.secret == null) {
                    SecureRandom random = new SecureRandom();
                    this.secret = new UUID(random.nextLong(), random.nextLong());
                }
            }
        }
        return this.secret;
    }

    public SecretKey getSecretAsKey() {
        if (this.secretKey == null) {
            this.secretKey = Encryption.uuidToKey(this.getSecret());
        }
        return this.secretKey;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
        if (authenticated) {
            this.lastKeepAlive = System.currentTimeMillis();
        } else {
            this.blockedSources.clear();
            this.showWebcams = true;
        }
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public long getLastKeepAlive() {
        return this.lastKeepAlive;
    }

    public void setLastKeepAlive(long lastKeepAliveResponse) {
        this.lastKeepAlive = lastKeepAliveResponse;
    }

    public void addBlockedSource(UUID uuid) {
        this.blockedSources.add(uuid);
    }

    public void removeBlockedSource(UUID uuid) {
        this.blockedSources.remove(uuid);
    }

    public boolean isSourceBlocked(UUID uuid) {
        return this.blockedSources.contains(uuid);
    }

    public void setShowWebcams(boolean showWebcams) {
        this.showWebcams = showWebcams;
    }

    public boolean canShowWebcams() {
        return this.showWebcams;
    }

    public boolean updateBroadcastPermission(boolean value) {
        return this.broadcastPermission.getAndSet(value);
    }

    public boolean hasBroadcastPermission() {
        return this.broadcastPermission.get();
    }

    public boolean updateViewPermission(boolean value) {
        return this.viewPermission.getAndSet(value);
    }

    public boolean hasViewPermission() {
        return this.viewPermission.get();
    }
}

