/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.util.UndashedUuid;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import ru.dimaskama.javah264.DecodeResult;
import ru.dimaskama.javah264.H264Decoder;
import ru.dimaskama.webcam.WebcamMod;
import ru.dimaskama.webcam.client.VideoPacketBuffer;
import ru.dimaskama.webcam.client.WebcamModClient;
import ru.dimaskama.webcam.client.cap.ImageUtil;
import ru.dimaskama.webcam.net.NalUnit;
import ru.dimaskama.webcam.net.VideoSource;

public class DisplayingVideo {
    private final UUID uuid;
    private final ResourceLocation textureId;
    private final H264Decoder decoder;
    private final VideoPacketBuffer buffer = new VideoPacketBuffer(WebcamModClient.CONFIG.getData().packetBufferSize(), this::acceptVideoPacket);
    private final AtomicReference<DecodeResult> newFrame = new AtomicReference();
    private volatile VideoSource lastSource;
    private long lastChunkTime;
    private NativeImage image;
    private DynamicTexture texture;

    public DisplayingVideo(UUID uuid) {
        this.uuid = uuid;
        this.textureId = WebcamMod.id("webcam_" + UndashedUuid.toString((UUID)uuid));
        try {
            this.decoder = H264Decoder.builder().flushBehavior(H264Decoder.FlushBehavior.NoFlush).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create H264Decoder", e);
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    public RenderData getRenderData() {
        DecodeResult newFrame = this.newFrame.getAndSet(null);
        if (newFrame != null) {
            NativeImage image = ImageUtil.createNativeImage(this.image, newFrame.getWidth(), newFrame.getHeight(), newFrame.getImage());
            if (image != this.image) {
                if (this.texture != null) {
                    this.texture.close();
                }
                this.texture = new DynamicTexture(() -> ((ResourceLocation)this.textureId).getPath(), image);
                this.texture.setFilter(true, false);
                Minecraft.getInstance().getTextureManager().register(this.textureId, (AbstractTexture)this.texture);
            } else {
                this.texture.upload();
            }
            this.image = image;
        }
        return this.texture != null ? new RenderData(this.lastSource, this.textureId) : null;
    }

    private static boolean sizeEquals(NativeImage image1, NativeImage image2) {
        return image1.getWidth() == image2.getWidth() && image1.getHeight() == image2.getHeight();
    }

    public long getLastChunkTime() {
        return this.lastChunkTime;
    }

    public void onVideoPacket(long time, VideoSource source, NalUnit nalUnit) {
        this.lastChunkTime = time;
        this.buffer.receivePacket(nalUnit.sequenceNumber(), nalUnit.data());
        this.lastSource = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptVideoPacket(byte[] nal) {
        DecodeResult decoded;
        H264Decoder h264Decoder = this.decoder;
        synchronized (h264Decoder) {
            decoded = this.decoder.decodeRGBA(nal);
        }
        if (decoded != null) {
            this.newFrame.set(decoded);
        }
    }

    public void close() {
        Minecraft.getInstance().getTextureManager().release(this.textureId);
    }

    public record RenderData(VideoSource source, ResourceLocation textureId) {
    }
}

