/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.cap;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSets;
import net.minecraft.network.chat.Component;
import nu.pattern.OpenCV;
import org.opencv.core.Core;
import org.opencv.videoio.VideoCapture;
import ru.dimaskama.webcam.Webcam;
import ru.dimaskama.webcam.client.WebcamModClient;
import ru.dimaskama.webcam.client.cap.CapturingDevice;
import ru.dimaskama.webcam.client.cap.DeviceException;
import ru.dimaskama.webcam.client.cap.DeviceOutputListener;
import ru.dimaskama.webcam.client.config.Resolution;

public class Capturing {
    private static final ObjectSortedSet<DeviceOutputListener> LISTENERS = ObjectSortedSets.synchronize((ObjectSortedSet)new ObjectLinkedOpenHashSet());
    private static final Int2ObjectMap<CapturingDevice> CAPTURING_DEVICES = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
    private static volatile IntList devices = IntList.of();
    private static volatile boolean updatingDevices;

    public static void init() {
        Webcam.getLogger().info("Loading OpenCV...");
        OpenCV.loadLocally();
        if (Webcam.isDebugMode()) {
            Webcam.getLogger().info("OpenCV build information: " + Core.getBuildInformation());
        }
    }

    public static synchronized void updateDevices() {
        updatingDevices = true;
        Webcam.getLogger().info("Updating available webcam devices. Some errors may be printed");
        CAPTURING_DEVICES.values().removeIf(d -> {
            d.close();
            return true;
        });
        devices = IntLists.unmodifiable((IntList)Capturing.listDevices());
        updatingDevices = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IntList listDevices() {
        int max = WebcamModClient.CONFIG.getData().maxDevices();
        IntArrayList list = new IntArrayList();
        for (int i = 0; i < max; ++i) {
            VideoCapture capture = null;
            try {
                capture = new VideoCapture(i);
                if (!capture.isOpened()) continue;
                list.add(i);
                continue;
            }
            finally {
                if (capture != null) {
                    capture.release();
                }
            }
        }
        return list;
    }

    public static IntList getDevices() {
        return devices;
    }

    public static void addListener(DeviceOutputListener listener) {
        LISTENERS.add((Object)listener);
    }

    public static void removeListener(DeviceOutputListener listener) {
        LISTENERS.remove((Object)listener);
    }

    public static boolean isCapturing(int deviceNumber) {
        CapturingDevice device = (CapturingDevice)CAPTURING_DEVICES.get(deviceNumber);
        return device != null && device.getError() == null;
    }

    public static void broadcastError(Component text) {
        DeviceException exception = new DeviceException(text);
        LISTENERS.forEach(listener -> listener.onError(exception));
    }

    public static void updateListeners() {
        if (!updatingDevices) {
            Capturing.updateListenersInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void updateListenersInternal() {
        if (!updatingDevices) {
            IntListIterator intListIterator = devices.iterator();
            while (intListIterator.hasNext()) {
                CapturingDevice device;
                int deviceNumber = (Integer)intListIterator.next();
                int frameListenerCount = 0;
                Resolution resolution = Resolution.R_1280X720;
                int fps = 30;
                int imageDimension = 360;
                ObjectSortedSet<DeviceOutputListener> objectSortedSet = LISTENERS;
                synchronized (objectSortedSet) {
                    for (DeviceOutputListener listener2 : LISTENERS) {
                        int imageDimensionOverride;
                        int fpsOverride;
                        Resolution resolutionOverride;
                        if (deviceNumber != listener2.getSelectedDevice()) continue;
                        if (listener2.isListeningFrames()) {
                            ++frameListenerCount;
                        }
                        if ((resolutionOverride = listener2.getResolution()) != null) {
                            resolution = resolutionOverride;
                        }
                        if ((fpsOverride = listener2.getFps()) != -1) {
                            fps = fpsOverride;
                        }
                        if ((imageDimensionOverride = listener2.getImageDimension()) == -1) continue;
                        imageDimension = imageDimensionOverride;
                    }
                }
                if (frameListenerCount != 0) {
                    device = (CapturingDevice)CAPTURING_DEVICES.computeIfAbsent(deviceNumber, i -> new CapturingDevice(i, new FrameConsumerImpl(i)));
                    device.setResolution(resolution);
                    device.setFps(fps);
                    device.setSquareDimension(imageDimension);
                    if (device.getState() == Thread.State.NEW) {
                        device.start();
                        continue;
                    }
                    Throwable error = device.getError();
                    if (error == null || !device.close()) continue;
                    DeviceException deviceException = DeviceException.wrap(deviceNumber, error);
                    LISTENERS.forEach(listener -> {
                        if (listener.getSelectedDevice() == deviceNumber) {
                            listener.onError(deviceException);
                        }
                    });
                    Webcam.getLogger().warn("Device error", deviceException);
                    continue;
                }
                device = (CapturingDevice)CAPTURING_DEVICES.remove(deviceNumber);
                if (device == null) continue;
                device.close();
            }
        }
    }

    private static class FrameConsumerImpl
    implements CapturingDevice.FrameConsumer {
        private final int deviceNumber;

        private FrameConsumerImpl(int deviceNumber) {
            this.deviceNumber = deviceNumber;
        }

        @Override
        public void consumeFrame(int fps, int width, int height, byte[] rgba) {
            LISTENERS.forEach(listener -> {
                if (this.deviceNumber == listener.getSelectedDevice() && listener.isListeningFrames()) {
                    listener.onFrame(this.deviceNumber, fps, width, height, rgba);
                }
            });
        }
    }
}

