/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.neoforge;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.lifecycle.ClientStartedEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import ru.dimaskama.webcam.client.WebcamClientService;
import ru.dimaskama.webcam.client.WebcamModClient;
import ru.dimaskama.webcam.client.neoforge.screen.AdvancedWebcamScreen;
import ru.dimaskama.webcam.client.render.WebcamHud;
import ru.dimaskama.webcam.message.Channel;
import ru.dimaskama.webcam.message.Message;
import ru.dimaskama.webcam.neoforge.WebcamNeoForgeMessaging;
import ru.dimaskama.webcam.net.packet.Packet;

@EventBusSubscriber(modid="webcam", value={Dist.CLIENT})
public class WebcamNeoForgeClientEvents {
    @SubscribeEvent
    private static void onClientStartedEvent(ClientStartedEvent event) {
        WebcamModClient.init(new WebcamClientService(){

            @Override
            public boolean canSendToServer(Channel<?> channel) {
                return Minecraft.getInstance().getConnection().hasChannel(WebcamNeoForgeMessaging.getPayloadType(channel));
            }

            @Override
            public void sendToServer(Message message) {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new WebcamNeoForgeMessaging.MessagePayload(WebcamNeoForgeMessaging.getPayloadType(message.getChannel()), message), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }

            @Override
            public void tickAdvancedConfigScreen(Minecraft minecraft) {
                AdvancedWebcamScreen.tick(minecraft);
            }

            @Override
            public Screen createAdvancedConfigScreen(@Nullable Screen parent) {
                return new AdvancedWebcamScreen().create(parent);
            }

            @Override
            public RenderType createWebcamRenderType(String name, RenderPipeline renderPipeline, ResourceLocation textureId) {
                return RenderType.create((String)name, (int)1536, (RenderPipeline)renderPipeline, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureId, false)).createCompositeState(false));
            }

            @Override
            public void recordPacket(Packet packet) {
            }
        });
    }

    @SubscribeEvent
    private static void onRegisterKeyMappingsEvent(RegisterKeyMappingsEvent event) {
        event.register(WebcamModClient.OPEN_WEBCAM_MENU_KEY);
    }

    @SubscribeEvent
    private static void onRenderGuiLayerEvent(RenderGuiLayerEvent.Post event) {
        if (event.getName().equals((Object)VanillaGuiLayers.CAMERA_OVERLAYS)) {
            WebcamHud.drawHud(event.getGuiGraphics(), Minecraft.getInstance().getDeltaTracker());
        }
    }

    @SubscribeEvent
    private static void onClientPlayerLoggingInEvent(ClientPlayerNetworkEvent.LoggingIn event) {
        WebcamModClient.onServerJoinEvent();
    }

    @SubscribeEvent
    private static void onClientTickEvent(ClientTickEvent.Post event) {
        WebcamModClient.onClientTick(Minecraft.getInstance());
    }

    @SubscribeEvent
    private static void onLevelTickEvent(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            WebcamModClient.onClientLevelTick(clientLevel);
        }
    }
}

