/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.net;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.lang.runtime.SwitchBootstraps;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import ru.dimaskama.webcam.Webcam;
import ru.dimaskama.webcam.client.AdaptableH264Encoder;
import ru.dimaskama.webcam.client.DisplayingVideoManager;
import ru.dimaskama.webcam.client.KnownSourceClient;
import ru.dimaskama.webcam.client.KnownSourceManager;
import ru.dimaskama.webcam.client.WebcamModClient;
import ru.dimaskama.webcam.client.cap.Capturing;
import ru.dimaskama.webcam.client.cap.DeviceException;
import ru.dimaskama.webcam.client.cap.DeviceOutputListener;
import ru.dimaskama.webcam.client.config.ClientConfig;
import ru.dimaskama.webcam.client.config.Resolution;
import ru.dimaskama.webcam.client.net.DecryptDecodeInboundS2CHandler;
import ru.dimaskama.webcam.client.net.EncodeEncryptOutboundC2SHandler;
import ru.dimaskama.webcam.config.SyncedServerConfig;
import ru.dimaskama.webcam.message.SecretMessage;
import ru.dimaskama.webcam.net.Encryption;
import ru.dimaskama.webcam.net.KnownSource;
import ru.dimaskama.webcam.net.NalUnit;
import ru.dimaskama.webcam.net.VideoSource;
import ru.dimaskama.webcam.net.packet.AddBlockedSourceC2SPacket;
import ru.dimaskama.webcam.net.packet.AuthAckPacket;
import ru.dimaskama.webcam.net.packet.AuthPacket;
import ru.dimaskama.webcam.net.packet.CloseSourceS2CPacket;
import ru.dimaskama.webcam.net.packet.KeepAlivePacket;
import ru.dimaskama.webcam.net.packet.KnownSourcesS2CPacket;
import ru.dimaskama.webcam.net.packet.Packet;
import ru.dimaskama.webcam.net.packet.PermissionsS2CPacket;
import ru.dimaskama.webcam.net.packet.ServerConfigPacket;
import ru.dimaskama.webcam.net.packet.ShowWebcamsC2SPacket;
import ru.dimaskama.webcam.net.packet.VideoC2SPacket;
import ru.dimaskama.webcam.net.packet.VideoS2CPacket;

public class WebcamClient
extends SimpleChannelInboundHandler<Packet>
implements DeviceOutputListener {
    private static final AtomicInteger THREAD_COUNT = new AtomicInteger();
    private static volatile EventLoopGroup eventLoopGroup;
    private static WebcamClient instance;
    private final UUID playerUuid;
    private final UUID secret;
    private final SecretKey secretKey;
    private final InetSocketAddress serverAddress;
    private final int keepAlivePeriod;
    private final Channel channel;
    private final AdaptableH264Encoder h264Encoder;
    private volatile boolean wasAuthenticated;
    private volatile boolean authenticated;
    private volatile SyncedServerConfig serverConfig = new SyncedServerConfig();
    private volatile long lastPacketTime;
    private volatile boolean broadcastPermission = true;
    private int nalSequenceNumber;
    private long lastAuthPacketSent;
    private int authAttempts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public WebcamClient(int port, String address, UUID playerUuid, UUID secret, int keepAlivePeriod) throws Exception {
        this.playerUuid = playerUuid;
        this.secret = secret;
        this.secretKey = Encryption.uuidToKey(secret);
        this.serverAddress = new InetSocketAddress(InetAddress.getByName(address), port);
        this.keepAlivePeriod = keepAlivePeriod;
        if (eventLoopGroup == null) {
            Class<WebcamClient> clazz = WebcamClient.class;
            // MONITORENTER : ru.dimaskama.webcam.client.net.WebcamClient.class
            if (eventLoopGroup == null) {
                eventLoopGroup = new NioEventLoopGroup(r -> {
                    Thread thread = new Thread(r, "Webcam Client #" + THREAD_COUNT.getAndIncrement());
                    thread.setDaemon(true);
                    return thread;
                });
            }
            // MONITOREXIT : clazz
        }
        this.channel = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decrypt_decode_s2c", (ChannelHandler)new DecryptDecodeInboundS2CHandler(WebcamClient.this));
                pipeline.addLast("packet_handler", (ChannelHandler)WebcamClient.this);
                pipeline.addLast("encode_encrypt_c2s", (ChannelHandler)new EncodeEncryptOutboundC2SHandler(WebcamClient.this));
            }
        })).bind(0).sync().channel();
        this.h264Encoder = new AdaptableH264Encoder();
        Capturing.addListener(this);
    }

    public static void initialize(UUID playerUuid, SocketAddress minecraftSocketAddress, SecretMessage secret) {
        String address;
        WebcamClient.shutdown();
        if (minecraftSocketAddress instanceof LocalAddress) {
            address = "127.0.0.1";
        } else if (minecraftSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress minecraftInetSocketAddress = (InetSocketAddress)minecraftSocketAddress;
            InetAddress inetAddress = minecraftInetSocketAddress.getAddress();
            address = inetAddress != null ? inetAddress.getHostAddress() : minecraftInetSocketAddress.getHostString();
        } else {
            throw new IllegalArgumentException("minecraftSocketAddress is not InetSocketAddress");
        }
        int port = secret.serverPort();
        if (!secret.host().isEmpty()) {
            try {
                URI uri = new URI("webcam://" + secret.host());
                String host = uri.getHost();
                int hostPort = uri.getPort();
                if (host != null) {
                    address = host;
                }
                if (hostPort > 0) {
                    port = hostPort;
                }
            }
            catch (Exception e) {
                Webcam.getLogger().warn("Failed to parse Webcam server host. Using Minecraft server address", e);
            }
        }
        try {
            instance = new WebcamClient(port, address, playerUuid, secret.secret(), secret.keepAlivePeriod());
            Webcam.getLogger().info("Connecting to Webcam server on address " + address + ":" + port);
        }
        catch (Exception e) {
            Webcam.getLogger().error("Failed to start Webcam client", e);
        }
    }

    public static void shutdown() {
        WebcamClient client = instance;
        instance = null;
        if (client != null) {
            try {
                client.close();
                Webcam.getLogger().info("Webcam client closed");
            }
            catch (Exception e) {
                Webcam.getLogger().error("Client shutdown error", e);
            }
        }
    }

    @Nullable
    public static WebcamClient getInstance() {
        return instance;
    }

    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public UUID getSecret() {
        return this.secret;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public InetSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void send(Packet packet) {
        this.channel.writeAndFlush((Object)packet);
    }

    public void sendBatching(Packet packet) {
        this.channel.write((Object)packet);
    }

    public void flushChannel() {
        this.channel.flush();
    }

    private void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
        if (authenticated) {
            this.wasAuthenticated = true;
            this.authAttempts = 0;
        } else {
            KnownSourceManager.INSTANCE.clear();
        }
    }

    public void close() {
        Capturing.removeListener(this);
        this.h264Encoder.close();
        try {
            this.channel.close().sync();
        }
        catch (Exception e) {
            Webcam.getLogger().error("Failed to close Webcam client channel", e);
        }
        this.setAuthenticated(false);
    }

    public void minecraftTick() {
        long time = System.currentTimeMillis();
        if (this.authenticated && time - this.lastPacketTime > 10L * (long)this.keepAlivePeriod) {
            this.setAuthenticated(false);
            Webcam.getLogger().warn("Webcam server timed out");
        }
        if (!this.authenticated && time - this.lastAuthPacketSent > 5000L) {
            if (++this.authAttempts <= 5) {
                this.send(new AuthPacket(this.getPlayerUuid(), this.getSecret()));
                this.lastAuthPacketSent = time;
                Webcam.getLogger().info("Attempting to " + (this.wasAuthenticated ? "reauthenticate" : "authenticate") + " to the Webcam server" + (String)(this.wasAuthenticated || this.authAttempts > 1 ? ". Attempt #" + this.authAttempts : ""));
            } else {
                Webcam.getLogger().warn("Could not authenticate to Webcam server");
                WebcamClient.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void channelRead0(ChannelHandlerContext ctx, Packet packet) {
        this.lastPacketTime = System.currentTimeMillis();
        WebcamModClient.getService().recordPacket(packet);
        Packet packet2 = packet;
        Objects.requireNonNull(packet2);
        Packet packet3 = packet2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AuthAckPacket.class, PermissionsS2CPacket.class, ServerConfigPacket.class, KeepAlivePacket.class, VideoS2CPacket.class, CloseSourceS2CPacket.class, KnownSourcesS2CPacket.class}, (Object)packet3, n)) {
            case 0: {
                AuthAckPacket ignored = (AuthAckPacket)packet3;
                this.setAuthenticated(true);
                Webcam.getLogger().info("Successfully authenticated to server");
                this.send(new ShowWebcamsC2SPacket(WebcamModClient.CONFIG.getData().showWebcams()));
                return;
            }
            case 1: {
                PermissionsS2CPacket permissionsS2CPacket = (PermissionsS2CPacket)packet3;
                try {
                    boolean bl;
                    boolean broadcast = bl = permissionsS2CPacket.broadcast();
                    boolean view = bl = permissionsS2CPacket.view();
                    this.broadcastPermission = broadcast;
                    DisplayingVideoManager.INSTANCE.setViewPermission(view);
                    return;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 2: {
                ServerConfigPacket serverConfigPacket = (ServerConfigPacket)packet3;
                {
                    SyncedServerConfig syncedServerConfig;
                    SyncedServerConfig config;
                    this.serverConfig = config = (syncedServerConfig = serverConfigPacket.config());
                    return;
                }
            }
            case 3: {
                KeepAlivePacket ignored = (KeepAlivePacket)packet3;
                this.send(KeepAlivePacket.INSTANCE);
                return;
            }
            case 4: {
                Object nal;
                VideoSource source;
                VideoS2CPacket videoS2CPacket = (VideoS2CPacket)packet3;
                {
                    Object object = videoS2CPacket.source();
                    source = object;
                    nal = object = videoS2CPacket.nal();
                }
                switch (DisplayingVideoManager.INSTANCE.onVideoPacket(source, (NalUnit)nal)) {
                    case WEBCAMS_ARE_DISABLED: {
                        this.send(new ShowWebcamsC2SPacket(false));
                        return;
                    }
                    case SOURCE_IS_BLOCKED: {
                        this.send(new AddBlockedSourceC2SPacket(source.getUuid()));
                        return;
                    }
                }
                return;
            }
            case 5: {
                UUID sourceUuid;
                CloseSourceS2CPacket closeSourceS2CPacket = (CloseSourceS2CPacket)packet3;
                {
                    UUID uUID;
                    sourceUuid = uUID = closeSourceS2CPacket.sourceUuid();
                }
                Minecraft.getInstance().execute(() -> DisplayingVideoManager.INSTANCE.remove(sourceUuid));
                return;
            }
            case 6: {
                Object list;
                KnownSourcesS2CPacket knownSourcesS2CPacket = (KnownSourcesS2CPacket)packet3;
                {
                    list = knownSourcesS2CPacket.sources();
                    List<KnownSource> sources = list;
                    list = sources.iterator();
                }
                while (list.hasNext()) {
                    KnownSource source = (KnownSource)list.next();
                    KnownSourceManager.INSTANCE.add(new KnownSourceClient(source));
                }
                return;
            }
        }
        throw new IllegalStateException("Can't handle packet " + String.valueOf(packet) + " from server");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (Webcam.isDebugMode()) {
            Webcam.getLogger().warn("Error processing packet on client", cause);
        }
    }

    @Override
    public int getSelectedDevice() {
        return WebcamModClient.CONFIG.getData().selectedDevice();
    }

    @Override
    @Nullable
    public Resolution getResolution() {
        return WebcamModClient.CONFIG.getData().webcamResolution();
    }

    @Override
    public int getFps() {
        return WebcamModClient.CONFIG.getData().webcamFps();
    }

    @Override
    public int getImageDimension() {
        return this.serverConfig.imageDimension();
    }

    @Override
    public boolean isListeningFrames() {
        return this.broadcastPermission && WebcamModClient.CONFIG.getData().webcamEnabled();
    }

    @Override
    public void onFrame(int deviceNumber, int fps, int width, int height, byte[] rgba) {
        ClientConfig clientConfig;
        if (this.isAuthenticated() && this.broadcastPermission && deviceNumber == (clientConfig = WebcamModClient.CONFIG.getData()).selectedDevice()) {
            SyncedServerConfig serverConfig = this.serverConfig;
            int mtu = serverConfig.mtu();
            int bitrate = Math.min(serverConfig.bitrate(), clientConfig.maxBitrate());
            for (byte[] nal : this.h264Encoder.encode(fps, mtu, bitrate, width, height, rgba)) {
                this.sendBatching(new VideoC2SPacket(new NalUnit(this.nalSequenceNumber++, nal)));
            }
            this.flushChannel();
        }
    }

    @Override
    public void onError(DeviceException e) {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.execute(() -> {
            if (minecraft.player != null) {
                minecraft.player.displayClientMessage((Component)Component.empty().append(e.getText()).withStyle(ChatFormatting.RED), true);
            }
        });
    }
}

