/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import ru.dimaskama.webcam.client.render.WebcamRenderTypes;
import ru.dimaskama.webcam.config.VideoDisplayShape;

public class WebcamRenderer {
    public static void render(ResourceLocation textureId, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, float halfWidth, float halfHeight, VideoDisplayShape shape) {
        switch (shape) {
            case SQUARE: {
                submitNodeCollector.submitCustomGeometry(poseStack, WebcamRenderTypes.square(textureId), (pose, consumer) -> WebcamRenderer.renderSquare(pose, consumer, halfWidth, halfHeight));
                break;
            }
            case ROUND: {
                submitNodeCollector.submitCustomGeometry(poseStack, WebcamRenderTypes.round(textureId), (pose, consumer) -> WebcamRenderer.renderRound(pose, consumer, halfWidth, halfHeight));
            }
        }
    }

    public static void renderSquare(PoseStack.Pose pose, VertexConsumer consumer, float halfWidth, float halfHeight) {
        consumer.addVertex(pose, -halfWidth, -halfHeight, 0.0f).setUv(0.0f, 0.0f);
        consumer.addVertex(pose, -halfWidth, halfHeight, 0.0f).setUv(0.0f, 1.0f);
        consumer.addVertex(pose, halfWidth, halfHeight, 0.0f).setUv(1.0f, 1.0f);
        consumer.addVertex(pose, halfWidth, -halfHeight, 0.0f).setUv(1.0f, 0.0f);
    }

    public static void renderRound(PoseStack.Pose pose, VertexConsumer consumer, float halfWidth, float halfHeight) {
        int numVertices = Mth.clamp((int)Math.round(50.265484f * halfWidth), (int)48, (int)360);
        consumer.addVertex(pose, 0.0f, 0.0f, 0.0f).setUv(0.5f, 0.5f);
        for (int i = 0; i <= numVertices; ++i) {
            float angle = (float)Math.PI * 2 * (float)i / (float)numVertices;
            float x = Mth.cos((float)angle);
            float y = -Mth.sin((float)angle);
            consumer.addVertex(pose, halfWidth * x, halfHeight * y, 0.0f).setUv(0.5f * (x + 1.0f), 0.5f * (y + 1.0f));
        }
    }
}

