/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.screen;

import com.mojang.blaze3d.platform.NativeImage;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import ru.dimaskama.webcam.Webcam;
import ru.dimaskama.webcam.WebcamMod;
import ru.dimaskama.webcam.client.WebcamModClient;
import ru.dimaskama.webcam.client.cap.Capturing;
import ru.dimaskama.webcam.client.cap.DeviceException;
import ru.dimaskama.webcam.client.cap.DeviceOutputListener;
import ru.dimaskama.webcam.client.cap.ImageUtil;
import ru.dimaskama.webcam.client.config.ClientConfig;
import ru.dimaskama.webcam.client.config.Resolution;
import ru.dimaskama.webcam.client.net.WebcamClient;
import ru.dimaskama.webcam.client.screen.widget.ClampedIntSlider;
import ru.dimaskama.webcam.client.screen.widget.DeviceSelectButton;
import ru.dimaskama.webcam.client.screen.widget.OnOffButton;
import ru.dimaskama.webcam.client.screen.widget.PlayersWebcamsButton;
import ru.dimaskama.webcam.client.screen.widget.ResolutionSelectButton;
import ru.dimaskama.webcam.client.screen.widget.StatusWidget;
import ru.dimaskama.webcam.client.screen.widget.UpdateDevicesButton;
import ru.dimaskama.webcam.net.packet.CloseSourceC2SPacket;
import ru.dimaskama.webcam.net.packet.ShowWebcamsC2SPacket;

public class WebcamScreen
extends Screen
implements DeviceOutputListener {
    public static final ResourceLocation BACKGROUND_SPRITE = WebcamMod.id("background");
    private static final ResourceLocation PREVIEW_TEXTURE = WebcamMod.id("webcam_preview");
    private static final int BUTTON_WIDTH = 152;
    private static final int MENU_HEIGHT = 167;
    private static final int PREVIEW_DIM = 142;
    private static boolean showPreview = true;
    private static int previewTextureDeviceIndex;
    private static DynamicTexture previewTexture;
    private final Screen parent;
    private final boolean notFromGame;
    private boolean firstInit = true;
    private boolean addedToWebcamListeners;
    private boolean configDirty;
    private int selectedDevice;
    private Resolution resolution;
    private int fps;
    private boolean showIcons;
    private int menuWidth;
    private int menuX;
    private int menuY;
    private Component errorMessage;
    private long errorMessageTime;

    public WebcamScreen(Screen parent) {
        this(parent, true);
    }

    public WebcamScreen(Screen parent, boolean notFromGame) {
        super((Component)Component.translatable((String)"webcam.screen.webcam"));
        this.parent = parent;
        this.notFromGame = notFromGame;
    }

    @Override
    public int getSelectedDevice() {
        return this.selectedDevice;
    }

    @Override
    @Nullable
    public Resolution getResolution() {
        return this.resolution;
    }

    @Override
    public int getFps() {
        return this.fps;
    }

    @Override
    public int getImageDimension() {
        return -1;
    }

    @Override
    public boolean isListeningFrames() {
        return showPreview || WebcamModClient.CONFIG.getData().webcamEnabled();
    }

    @Override
    public void onFrame(int deviceNumber, int fps, int width, int height, byte[] rgba) {
        Minecraft.getInstance().execute(() -> {
            block5: {
                try {
                    if (deviceNumber == this.selectedDevice) {
                        previewTextureDeviceIndex = this.selectedDevice;
                        NativeImage prevImage = previewTexture != null ? previewTexture.getPixels() : null;
                        NativeImage newImage = ImageUtil.createNativeImage(prevImage, width, height, rgba);
                        if (newImage != prevImage) {
                            previewTexture = new DynamicTexture(() -> ((ResourceLocation)PREVIEW_TEXTURE).getPath(), newImage);
                            previewTexture.setFilter(true, false);
                            this.minecraft.getTextureManager().register(PREVIEW_TEXTURE, (AbstractTexture)previewTexture);
                        } else {
                            previewTexture.upload();
                        }
                    }
                }
                catch (Exception e) {
                    if (!Webcam.isDebugMode()) break block5;
                    Webcam.getLogger().warn("Preview error", e);
                }
            }
        });
    }

    @Override
    public void onError(DeviceException e) {
        this.errorMessage = e.getText();
        this.errorMessageTime = System.currentTimeMillis();
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    protected void init() {
        if (!this.addedToWebcamListeners) {
            this.addedToWebcamListeners = true;
            Capturing.addListener(this);
        }
        ClientConfig config = WebcamModClient.CONFIG.getData();
        if (this.firstInit) {
            this.firstInit = false;
            this.selectedDevice = config.selectedDevice();
            this.resolution = config.webcamResolution();
            this.fps = config.webcamFps();
            this.showIcons = config.showIcons();
        }
        this.menuWidth = 160 + (showPreview ? 144 : 0);
        this.menuX = this.width - this.menuWidth >> 1;
        this.menuY = this.height - 167 >> 1;
        int buttonY = this.menuY + 21;
        this.addRenderableWidget((GuiEventListener)new OnOffButton(this.menuX + 4, buttonY, 152, 16, "webcam.screen.webcam.show_webcams", config.showWebcams(), b -> this.updateAndSetConfig(WebcamModClient.CONFIG.getData().withShowWebcams(b))));
        this.addRenderableWidget((GuiEventListener)new OnOffButton(this.menuX + 4, buttonY += 18, 152, 16, "webcam.screen.webcam.webcam_enabled", config.webcamEnabled(), b -> this.updateAndSetConfig(WebcamModClient.CONFIG.getData().withWebcamEnabled(b))));
        this.addRenderableWidget((GuiEventListener)new DeviceSelectButton(this.menuX + 4, buttonY += 18, 135, 16, this.selectedDevice, i -> {
            this.selectedDevice = i;
        }));
        this.addRenderableWidget((GuiEventListener)new UpdateDevicesButton(this.menuX + 152 - 12, buttonY, 16, 16));
        this.addRenderableWidget((GuiEventListener)new ResolutionSelectButton(this.menuX + 4, buttonY += 18, 152, 16, this.resolution, r -> {
            this.resolution = r;
        }));
        ((ClampedIntSlider)this.addRenderableWidget((GuiEventListener)new ClampedIntSlider(this.menuX + 4, buttonY += 18, 152, 16, "webcam.screen.webcam.fps", 5, 60, this.fps, i -> {
            this.fps = i;
        }))).setTooltip(Tooltip.create((Component)Component.translatable((String)"webcam.screen.webcam.fps.tooltip")));
        this.addRenderableWidget((GuiEventListener)new OnOffButton(this.menuX + 4, buttonY += 18, 152, 16, "webcam.screen.webcam.show_icons", this.showIcons, b -> {
            this.showIcons = b;
        }));
        this.addRenderableWidget((GuiEventListener)new OnOffButton(this.menuX + 4, buttonY += 18, 152, 16, "webcam.screen.webcam.show_preview", showPreview, b -> {
            showPreview = b;
            this.rebuildWidgets();
        }));
        Button advanced = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"webcam.screen.webcam.advanced"), button -> {
            if (this.parent != null && this.notFromGame) {
                this.minecraft.setScreen(this.parent);
            } else {
                this.minecraft.setScreen(WebcamModClient.getService().createAdvancedConfigScreen(this));
            }
        }).bounds(this.menuX + 4, buttonY += 18, 152, 16).build());
        if (!WebcamModClient.canUseAdvancedConfigScreen()) {
            advanced.setTooltip(Tooltip.create((Component)Component.translatable((String)"webcam.screen.webcam.advanced.not_available")));
            advanced.active = false;
        }
        this.addRenderableWidget((GuiEventListener)new StatusWidget(this.menuX + 4, this.menuY + 4, 16, 16));
        this.addRenderableWidget((GuiEventListener)new PlayersWebcamsButton(this.menuX + this.menuWidth - 20, this.menuY + 4, 16, 16));
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.renderBackground(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, BACKGROUND_SPRITE, this.menuX, this.menuY, this.menuWidth, 167);
        guiGraphics.drawString(this.font, this.title, this.width - this.font.width((FormattedText)this.title) >> 1, this.menuY + 7, -11184811, false);
        if (this.errorMessage != null && System.currentTimeMillis() - this.errorMessageTime <= 4000L) {
            guiGraphics.drawCenteredString(this.font, this.errorMessage, this.width >> 1, this.menuY + 167 + 10, -43691);
        }
        if (showPreview && previewTexture != null && this.selectedDevice == previewTextureDeviceIndex && Capturing.isCapturing(this.selectedDevice)) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, PREVIEW_TEXTURE, this.menuX + this.menuWidth - 142 - 4, this.menuY + 21, 0.0f, 0.0f, 142, 142, 142, 142);
        }
    }

    public boolean isPauseScreen() {
        return this.notFromGame;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public void removed() {
        ClientConfig oldConfig = WebcamModClient.CONFIG.getData();
        ClientConfig newConfig = new ClientConfig(oldConfig.showWebcams(), oldConfig.webcamEnabled(), this.selectedDevice, this.resolution, this.fps, this.showIcons, oldConfig.maxDevices(), oldConfig.packetBufferSize(), oldConfig.maxBitrate(), oldConfig.hud());
        if (this.configDirty || !newConfig.equals(oldConfig)) {
            this.configDirty = false;
            this.updateConfig(oldConfig, newConfig);
            WebcamModClient.CONFIG.setData(newConfig);
            WebcamModClient.CONFIG.save();
        }
        Capturing.removeListener(this);
        this.addedToWebcamListeners = false;
    }

    private void updateConfig(ClientConfig oldConfig, ClientConfig newConfig) {
        WebcamClient webcamClient;
        if (oldConfig.webcamEnabled() && !newConfig.webcamEnabled() && (webcamClient = WebcamClient.getInstance()) != null && webcamClient.isAuthenticated()) {
            webcamClient.send(CloseSourceC2SPacket.INSTANCE);
        }
        if (oldConfig.showWebcams() != newConfig.showWebcams() && (webcamClient = WebcamClient.getInstance()) != null && webcamClient.isAuthenticated()) {
            webcamClient.send(new ShowWebcamsC2SPacket(newConfig.showWebcams()));
        }
    }

    private void updateAndSetConfig(ClientConfig newConfig) {
        ClientConfig oldConfig = WebcamModClient.CONFIG.getData();
        if (!oldConfig.equals(newConfig)) {
            WebcamModClient.CONFIG.setData(newConfig);
            this.configDirty = true;
            this.updateConfig(oldConfig, newConfig);
        }
    }
}

