/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.screen.widget;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import ru.dimaskama.webcam.WebcamMod;

public class HideWebcamButton
extends AbstractButton {
    private static final ResourceLocation BLOCKED_SPRITE = WebcamMod.id("webcam_disabled");
    private static final ResourceLocation NOT_BLOCKED_SPRITE = WebcamMod.id("webcam");
    private final BooleanConsumer consumer;
    private boolean blocked;

    public HideWebcamButton(boolean blocked, BooleanConsumer consumer) {
        super(-999, -999, 0, 0, (Component)Component.empty());
        this.consumer = consumer;
        this.blocked = blocked;
        this.update();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        int spriteX = this.getX() + (this.getWidth() - 16 >> 1);
        int spriteY = this.getY() + (this.getHeight() - 16 >> 1);
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.blocked ? BLOCKED_SPRITE : NOT_BLOCKED_SPRITE, spriteX, spriteY, 16, 16, -1);
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int i) {
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
        this.blocked = !this.blocked;
        this.update();
        this.consumer.accept(this.blocked);
    }

    private void update() {
        this.setMessage((Component)(this.blocked ? Component.translatable((String)"webcam.screen.players_webcams.show") : Component.translatable((String)"webcam.screen.players_webcams.hide")));
        this.setTooltip(Tooltip.create((Component)this.getMessage()));
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }
}

