/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import ru.dimaskama.webcam.WebcamEvents;
import ru.dimaskama.webcam.command.WebcamconfigModCommand;
import ru.dimaskama.webcam.neoforge.WebcamNeoForge;

@EventBusSubscriber(modid="webcam")
public class WebcamNeoForgeEvents {
    @SubscribeEvent
    private static void onServerStartedEvent(ServerStartedEvent event) {
        WebcamNeoForge.setServer(event.getServer());
        WebcamEvents.onMinecraftServerStarted();
    }

    @SubscribeEvent
    private static void onServerTickEvent(ServerTickEvent.Post event) {
        WebcamEvents.onMinecraftServerTick();
    }

    @SubscribeEvent
    private static void onServerStoppingEvent(ServerStoppingEvent event) {
        WebcamEvents.onMinecraftServerStopping();
        WebcamNeoForge.setServer(null);
    }

    @SubscribeEvent
    private static void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            WebcamEvents.onPlayerDisconnected(player2.getUUID());
        }
    }

    @SubscribeEvent
    private static void onRegisterCommandsEvent(RegisterCommandsEvent event) {
        WebcamconfigModCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

