/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.net;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Encryption {
    private static final int IV_LENGTH = 12;
    private static final int TAG_LENGTH_BIT = 128;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    public static SecretKey uuidToKey(UUID uuid) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        return new SecretKeySpec(buffer.array(), "AES");
    }

    public static byte[] encrypt(byte[] data, int offset, int length, SecretKey secretKey) throws Exception {
        byte[] iv = new byte[12];
        SECURE_RANDOM.nextBytes(iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)secretKey, spec);
        byte[] cipherText = cipher.doFinal(data, offset, length);
        byte[] payload = new byte[12 + cipherText.length];
        System.arraycopy(iv, 0, payload, 0, 12);
        System.arraycopy(cipherText, 0, payload, 12, cipherText.length);
        return payload;
    }

    public static byte[] decrypt(ByteBuf buf, SecretKey secretKey) throws Exception {
        byte[] iv = new byte[12];
        buf.readBytes(iv);
        byte[] cipherText = new byte[buf.readableBytes()];
        buf.readBytes(cipherText);
        return Encryption.decrypt(iv, cipherText, secretKey);
    }

    private static byte[] decrypt(byte[] iv, byte[] cipherText, SecretKey secretKey) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)secretKey, spec);
        return cipher.doFinal(cipherText);
    }
}

