/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import ru.dimaskama.webcam.server.PlayerState;
import ru.dimaskama.webcam.server.S2CEncodedPacket;
import ru.dimaskama.webcam.server.S2CPacket;

public class EncodeOutboundS2CHandler
extends ChannelOutboundHandlerAdapter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        Object packet;
        PlayerState target;
        if (!(msg instanceof S2CPacket)) {
            ctx.write(msg);
            return;
        }
        S2CPacket s2CPacket = (S2CPacket)msg;
        try {
            Object object = s2CPacket.target();
            target = object;
            packet = object = s2CPacket.packet();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        ByteBuf buf = ctx.alloc().buffer(packet.getEstimatedSizeWithId());
        packet.encodeWithId(buf);
        ctx.write((Object)new S2CEncodedPacket(target, buf));
    }
}

