/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.javah264;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;
import ru.dimaskama.javah264.DecodeResult;
import ru.dimaskama.javah264.OpenH264Lib;
import ru.dimaskama.javah264.exception.UnknownPlatformException;

public class H264Decoder
implements AutoCloseable {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final long pointer;

    public H264Decoder() throws IOException, UnknownPlatformException {
        this(new Builder());
    }

    public H264Decoder(Builder builder) throws IOException, UnknownPlatformException {
        OpenH264Lib.load();
        this.pointer = H264Decoder.createDecoder0(builder.flushBehavior.ordinal());
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public DecodeResult decodeRGBA(byte[] packet) {
        this.assertNotClosed();
        return H264Decoder.decodeRGBA0(this.pointer, Objects.requireNonNull(packet, "packet"));
    }

    @Nullable
    public DecodeResult decodeRGB(byte[] packet) {
        this.assertNotClosed();
        return H264Decoder.decodeRGB0(this.pointer, Objects.requireNonNull(packet, "packet"));
    }

    public DecodeResult[] flushRemainingRGBA() {
        this.assertNotClosed();
        return H264Decoder.flushRemainingRGBA0(this.pointer);
    }

    public DecodeResult[] flushRemainingRGB() {
        this.assertNotClosed();
        return H264Decoder.flushRemainingRGB0(this.pointer);
    }

    private void assertNotClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("This H264Decoder instance is closed!");
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            H264Decoder.destroyDecoder0(this.pointer);
        }
    }

    public static byte[][] nalUnits(byte[] h264data) throws IOException, UnknownPlatformException {
        OpenH264Lib.load();
        return H264Decoder.nalUnits0(h264data);
    }

    private static native long createDecoder0(int var0) throws IOException;

    private static native DecodeResult decodeRGBA0(long var0, byte[] var2);

    private static native DecodeResult decodeRGB0(long var0, byte[] var2);

    public static native DecodeResult[] flushRemainingRGBA0(long var0);

    public static native DecodeResult[] flushRemainingRGB0(long var0);

    private static native void destroyDecoder0(long var0);

    private static native byte[][] nalUnits0(byte[] var0);

    public static enum FlushBehavior {
        Auto,
        Flush,
        NoFlush;

    }

    public static class Builder {
        private FlushBehavior flushBehavior = FlushBehavior.Auto;

        private Builder() {
        }

        public Builder flushBehavior(FlushBehavior value) {
            this.flushBehavior = value;
            return this;
        }

        public H264Decoder build() throws IOException, UnknownPlatformException {
            return new H264Decoder(this);
        }
    }
}

