/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client;

import java.nio.file.Path;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_638;
import ru.dimaskama.webcam.Webcam;
import ru.dimaskama.webcam.WebcamMod;
import ru.dimaskama.webcam.client.DisplayingVideoManager;
import ru.dimaskama.webcam.client.WebcamClientService;
import ru.dimaskama.webcam.client.cap.Capturing;
import ru.dimaskama.webcam.client.compat.IrisCompat;
import ru.dimaskama.webcam.client.config.BlockedSources;
import ru.dimaskama.webcam.client.config.ClientConfig;
import ru.dimaskama.webcam.client.net.WebcamClient;
import ru.dimaskama.webcam.client.render.WebcamRenderTypes;
import ru.dimaskama.webcam.client.screen.WebcamScreen;
import ru.dimaskama.webcam.client.screen.widget.UpdateDevicesButton;
import ru.dimaskama.webcam.config.JsonConfig;
import ru.dimaskama.webcam.message.Channel;
import ru.dimaskama.webcam.message.Message;
import ru.dimaskama.webcam.message.SecretMessage;
import ru.dimaskama.webcam.message.SecretRequestMessage;

public class WebcamModClient {
    public static final JsonConfig<ClientConfig> CONFIG = new JsonConfig<ClientConfig>(Path.of("./config/webcam/client.json", new String[0]).toString(), ClientConfig.CODEC, ClientConfig::new);
    public static final JsonConfig<BlockedSources> BLOCKED_SOURCES = new JsonConfig<BlockedSources>(Path.of("./config/webcam/blocked_sources.json", new String[0]).toString(), BlockedSources.CODEC, BlockedSources::new);
    public static final class_304.class_11900 KEY_CATEGORY = new class_304.class_11900(WebcamMod.id("webcam"));
    public static final class_304 OPEN_WEBCAM_MENU_KEY = new class_304("key.webcam.open_menu", class_3675.class_307.field_1668, 67, KEY_CATEGORY);
    private static WebcamClientService service;
    private static boolean canUseAdvancedConfigScreen;

    public static void init(WebcamClientService service) {
        WebcamModClient.service = service;
        canUseAdvancedConfigScreen = WebcamMod.getService().isModLoaded("cloth-config") || WebcamMod.getService().isModLoaded("cloth_config");
        CONFIG.loadOrCreate();
        BLOCKED_SOURCES.loadOrCreate();
        Capturing.init();
        UpdateDevicesButton.updateDevices();
        WebcamRenderTypes.init();
        IrisCompat.init();
    }

    public static WebcamClientService getService() {
        return service;
    }

    public static boolean canUseAdvancedConfigScreen() {
        return canUseAdvancedConfigScreen;
    }

    public static void onServerJoinEvent() {
        if (!Webcam.getService().isInReplay() && service.canSendToServer(Channel.SECRET_REQUEST)) {
            Webcam.getLogger().info("Sending secret request");
            service.sendToServer(new SecretRequestMessage(Webcam.getVersion()));
        }
    }

    public static void onClientTick(class_310 minecraft) {
        WebcamClient client = WebcamClient.getInstance();
        if (client != null) {
            client.minecraftTick();
        }
        Capturing.updateListeners();
        while (OPEN_WEBCAM_MENU_KEY.method_1436()) {
            minecraft.method_1507((class_437)new WebcamScreen(null, false));
        }
        if (WebcamModClient.canUseAdvancedConfigScreen()) {
            service.tickAdvancedConfigScreen(minecraft);
        }
    }

    public static void onClientLevelTick(class_638 level) {
        if (level.method_54719().method_54751()) {
            DisplayingVideoManager.INSTANCE.levelTick();
        }
    }

    public static void onMessageReceived(Message message) {
        if (message instanceof SecretMessage) {
            SecretMessage secretMessage = (SecretMessage)message;
            WebcamModClient.onSecretMessageReceived(secretMessage);
            return;
        }
        throw new IllegalStateException("Can't handle message " + String.valueOf(message) + " of channel " + message.getChannel().getId() + " on client");
    }

    private static void onSecretMessageReceived(SecretMessage secret) {
        if (!Webcam.getService().isInReplay()) {
            Webcam.getLogger().info("Received Webcam secret");
            class_310 minecraft = class_310.method_1551();
            WebcamClient.initialize(minecraft.field_1724.method_5667(), minecraft.method_1562().method_48296().method_10755(), secret);
        }
    }
}

