/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.net;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import java.util.UUID;
import ru.dimaskama.webcam.Webcam;
import ru.dimaskama.webcam.client.net.WebcamClient;
import ru.dimaskama.webcam.net.Encryption;
import ru.dimaskama.webcam.net.packet.Packet;

public class DecryptDecodeInboundS2CHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private final WebcamClient client;

    public DecryptDecodeInboundS2CHandler(WebcamClient client) {
        this.client = client;
    }

    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg.content();
        if (buf.readByte() != -18) {
            throw new IllegalArgumentException("Invalid S2C packet");
        }
        UUID target = new UUID(buf.readLong(), buf.readLong());
        if (!this.client.getPlayerUuid().equals(target)) {
            throw new IllegalArgumentException("Packet is targeted to a different player");
        }
        byte[] decrypted = Encryption.decrypt(buf, this.client.getSecretKey());
        Packet packet = Packet.decodeById(Unpooled.wrappedBuffer((byte[])decrypted));
        ctx.fireChannelRead((Object)packet);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (Webcam.isDebugMode()) {
            Webcam.getLogger().warn("Failed to decode S2C packet", cause);
        }
    }
}

