/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.net.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import ru.dimaskama.webcam.net.packet.AddBlockedSourceC2SPacket;
import ru.dimaskama.webcam.net.packet.AuthAckPacket;
import ru.dimaskama.webcam.net.packet.AuthPacket;
import ru.dimaskama.webcam.net.packet.CloseSourceC2SPacket;
import ru.dimaskama.webcam.net.packet.CloseSourceS2CPacket;
import ru.dimaskama.webcam.net.packet.KeepAlivePacket;
import ru.dimaskama.webcam.net.packet.KnownSourcesS2CPacket;
import ru.dimaskama.webcam.net.packet.Packet;
import ru.dimaskama.webcam.net.packet.PermissionsS2CPacket;
import ru.dimaskama.webcam.net.packet.RemoveBlockedSourceC2SPacket;
import ru.dimaskama.webcam.net.packet.ServerConfigPacket;
import ru.dimaskama.webcam.net.packet.ShowWebcamsC2SPacket;
import ru.dimaskama.webcam.net.packet.VideoC2SPacket;
import ru.dimaskama.webcam.net.packet.VideoS2CPacket;

public final class PacketType<T extends Packet> {
    private static final List<PacketType<?>> REGISTRY = new ArrayList();
    public static final PacketType<AuthPacket> AUTH = PacketType.register(AuthPacket::new);
    public static final PacketType<AuthAckPacket> AUTH_ACK = PacketType.register(b -> AuthAckPacket.INSTANCE);
    public static final PacketType<ServerConfigPacket> SERVER_CONFIG = PacketType.register(ServerConfigPacket::new);
    public static final PacketType<KeepAlivePacket> KEEP_ALIVE = PacketType.register(b -> KeepAlivePacket.INSTANCE);
    public static final PacketType<VideoC2SPacket> VIDEO_C2S = PacketType.register(VideoC2SPacket::new);
    public static final PacketType<VideoS2CPacket> VIDEO_S2C = PacketType.register(VideoS2CPacket::new);
    public static final PacketType<CloseSourceC2SPacket> CLOSE_SOURCE_C2S = PacketType.register(b -> CloseSourceC2SPacket.INSTANCE);
    public static final PacketType<CloseSourceS2CPacket> CLOSE_SOURCE_S2C = PacketType.register(CloseSourceS2CPacket::new);
    public static final PacketType<ShowWebcamsC2SPacket> SHOW_WEBCAMS_C2S = PacketType.register(ShowWebcamsC2SPacket::new);
    public static final PacketType<AddBlockedSourceC2SPacket> ADD_BLOCKED_SOURCE_C2S = PacketType.register(AddBlockedSourceC2SPacket::new);
    public static final PacketType<RemoveBlockedSourceC2SPacket> REMOVE_BLOCKED_SOURCE_C2S = PacketType.register(RemoveBlockedSourceC2SPacket::new);
    public static final PacketType<KnownSourcesS2CPacket> KNOWN_SOURCES_S2C = PacketType.register(KnownSourcesS2CPacket::new);
    public static final PacketType<PermissionsS2CPacket> PERMISSIONS_S2C = PacketType.register(PermissionsS2CPacket::decode);
    private final byte id;
    private final Function<ByteBuf, T> decoder;

    private PacketType(byte id, Function<ByteBuf, T> decoder) {
        this.id = id;
        this.decoder = decoder;
    }

    public byte getId() {
        return this.id;
    }

    public T decode(ByteBuf buf) {
        return (T)((Packet)this.decoder.apply(buf));
    }

    public static PacketType<?> byId(byte id) {
        if (id < 0 || id >= REGISTRY.size()) {
            throw new IllegalArgumentException("Unknown packet type with id " + id);
        }
        return REGISTRY.get(id);
    }

    public static <T extends Packet> PacketType<T> register(Function<ByteBuf, T> decoder) {
        int idInt = REGISTRY.size();
        if (idInt > 255) {
            throw new IllegalStateException("Too many packet types registered");
        }
        byte id = (byte)idInt;
        PacketType<T> packetType = new PacketType<T>(id, decoder);
        REGISTRY.add(packetType);
        return packetType;
    }
}

