/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.UUID;
import ru.dimaskama.webcam.Webcam;
import ru.dimaskama.webcam.net.Encryption;
import ru.dimaskama.webcam.net.packet.Packet;
import ru.dimaskama.webcam.server.C2SPacket;
import ru.dimaskama.webcam.server.PlayerState;
import ru.dimaskama.webcam.server.WebcamServer;

public class DecryptDecodeInboundC2SHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private final WebcamServer server;

    public DecryptDecodeInboundC2SHandler(WebcamServer server) {
        this.server = server;
    }

    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg.content();
        if (buf.readByte() != -52) {
            throw new IllegalArgumentException("Invalid C2S packet");
        }
        UUID sender = new UUID(buf.readLong(), buf.readLong());
        PlayerState player = this.server.getPlayerState(sender);
        if (player == null) {
            throw new IllegalArgumentException("Unknown player " + String.valueOf(sender));
        }
        byte[] decrypted = Encryption.decrypt(buf, player.getSecretAsKey());
        Packet packet = Packet.decodeById(Unpooled.wrappedBuffer((byte[])decrypted));
        player.setSocketAddress((InetSocketAddress)msg.sender());
        ctx.fireChannelRead((Object)new C2SPacket(player, packet));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (Webcam.isDebugMode()) {
            Webcam.getLogger().warn("Failed to decode C2S packet", cause);
        }
    }
}

