/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.server;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.lang.runtime.SwitchBootstraps;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import ru.dimaskama.webcam.Webcam;
import ru.dimaskama.webcam.WebcamService;
import ru.dimaskama.webcam.config.ServerConfig;
import ru.dimaskama.webcam.net.KnownSource;
import ru.dimaskama.webcam.net.NalUnit;
import ru.dimaskama.webcam.net.VideoSource;
import ru.dimaskama.webcam.net.packet.AddBlockedSourceC2SPacket;
import ru.dimaskama.webcam.net.packet.AuthAckPacket;
import ru.dimaskama.webcam.net.packet.AuthPacket;
import ru.dimaskama.webcam.net.packet.CloseSourceC2SPacket;
import ru.dimaskama.webcam.net.packet.CloseSourceS2CPacket;
import ru.dimaskama.webcam.net.packet.KeepAlivePacket;
import ru.dimaskama.webcam.net.packet.KnownSourcesS2CPacket;
import ru.dimaskama.webcam.net.packet.Packet;
import ru.dimaskama.webcam.net.packet.PermissionsS2CPacket;
import ru.dimaskama.webcam.net.packet.RemoveBlockedSourceC2SPacket;
import ru.dimaskama.webcam.net.packet.ServerConfigPacket;
import ru.dimaskama.webcam.net.packet.ShowWebcamsC2SPacket;
import ru.dimaskama.webcam.net.packet.VideoC2SPacket;
import ru.dimaskama.webcam.net.packet.VideoS2CPacket;
import ru.dimaskama.webcam.server.C2SPacket;
import ru.dimaskama.webcam.server.DecryptDecodeInboundC2SHandler;
import ru.dimaskama.webcam.server.EncodeOutboundS2CHandler;
import ru.dimaskama.webcam.server.EncryptOutboundS2CHandler;
import ru.dimaskama.webcam.server.KeepAliveThread;
import ru.dimaskama.webcam.server.PlayerState;
import ru.dimaskama.webcam.server.S2CEncodedPacket;
import ru.dimaskama.webcam.server.S2CPacket;

public class WebcamServer
extends SimpleChannelInboundHandler<C2SPacket> {
    private static final AtomicInteger THREAD_COUNT = new AtomicInteger();
    private static EventLoopGroup eventLoopGroup;
    private static WebcamServer instance;
    private final Map<UUID, PlayerState> playerStateMap = new ConcurrentHashMap<UUID, PlayerState>();
    private final int port;
    private final String address;
    private final String host;
    private final int keepAlivePeriod;
    private final Channel channel;
    private final KeepAliveThread keepAliveThread;
    private int minecraftTickCount;

    public WebcamServer(int port, String address, String host, int keepAlivePeriod) throws Exception {
        this.port = port;
        this.address = address.isEmpty() ? "0.0.0.0" : address;
        this.host = host;
        this.keepAlivePeriod = keepAlivePeriod;
        if (eventLoopGroup == null) {
            eventLoopGroup = new NioEventLoopGroup(r -> {
                Thread thread = new Thread(r, "Webcam Server #" + THREAD_COUNT.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            });
        }
        this.channel = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decrypt_decode_c2s", (ChannelHandler)new DecryptDecodeInboundC2SHandler(WebcamServer.this));
                pipeline.addLast("packet_handler", (ChannelHandler)WebcamServer.this);
                pipeline.addLast("encrypt_s2c", (ChannelHandler)new EncryptOutboundS2CHandler());
                pipeline.addLast("encode_s2c", (ChannelHandler)new EncodeOutboundS2CHandler());
            }
        })).bind((SocketAddress)new InetSocketAddress(address.isEmpty() ? null : InetAddress.getByName(address), port)).sync().channel();
        this.keepAliveThread = new KeepAliveThread(this);
        this.keepAliveThread.start();
    }

    public static void initialize(ServerConfig config) {
        WebcamServer.shutdown();
        String host = config.host();
        if (!host.isEmpty()) {
            try {
                new URI("webcam://" + host);
                Webcam.getLogger().info("Webcam host is \"" + host + "\"");
            }
            catch (URISyntaxException e) {
                Webcam.getLogger().warn("Failed to parse Webcam host", e);
                host = "";
            }
        }
        try {
            int port = config.port();
            String address = config.bindAddress();
            int keepAlivePeriod = config.keepAlivePeriod();
            WebcamServer server = instance = new WebcamServer(port, address, host, keepAlivePeriod);
            Webcam.getLogger().info("Webcam server started on " + server.address + ":" + server.port + (String)(host.isEmpty() ? "" : ". Host: " + host));
        }
        catch (Exception e) {
            Webcam.getLogger().warn("Failed to open Webcam server", e);
        }
    }

    public static void shutdown() {
        WebcamServer server = instance;
        instance = null;
        if (server != null) {
            try {
                server.close();
                Webcam.getLogger().info("Webcam server closed");
            }
            catch (Exception e) {
                Webcam.getLogger().error("Webcam server close error", e);
            }
        }
    }

    @Nullable
    public static WebcamServer getInstance() {
        return instance;
    }

    public int getPort() {
        return this.port;
    }

    public int getKeepAlivePeriod() {
        return this.keepAlivePeriod;
    }

    public String getHost() {
        return this.host;
    }

    public PlayerState getOrCreatePlayerState(UUID playerUuid, String playerName) {
        return this.playerStateMap.computeIfAbsent(playerUuid, u -> new PlayerState((UUID)u, playerName));
    }

    @Nullable
    public PlayerState getPlayerState(UUID playerUuid) {
        return this.playerStateMap.get(playerUuid);
    }

    public void disconnectPlayer(UUID playerUuid) {
        this.playerStateMap.remove(playerUuid);
    }

    public void send(PlayerState target, Packet packet) {
        this.send(new S2CPacket(target, packet));
    }

    public void send(S2CPacket packet) {
        this.channel.writeAndFlush((Object)packet);
    }

    public void sendBatching(PlayerState target, Packet packet) {
        this.sendBatching(new S2CPacket(target, packet));
    }

    public void sendBatching(S2CPacket packet) {
        this.channel.write((Object)packet);
    }

    public void sendBatching(S2CEncodedPacket packet) {
        this.channel.write((Object)packet);
    }

    public void flushChannel() {
        this.channel.flush();
    }

    public void broadcast(Packet packet) {
        this.broadcastNoRelease(Unpooled.buffer((int)packet.getEstimatedSizeWithId()), packet, p -> true);
    }

    private void broadcastNoRelease(ByteBuf buf, Packet packet, Predicate<PlayerState> filter) {
        packet.encodeWithId(buf);
        this.playerStateMap.values().forEach(p -> {
            if (p.isAuthenticated() && filter.test((PlayerState)p)) {
                this.sendBatching(new S2CEncodedPacket((PlayerState)p, buf.retainedDuplicate()));
            }
        });
        this.flushChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastVideoNearby(UUID player, ByteBuf buf, Packet packet, double maxDist, boolean includeSelf, boolean force) {
        try {
            Webcam.getService().acceptForNearbyPlayers(player, maxDist, players -> this.broadcastNoRelease(buf, packet, p -> (force || p.hasViewPermission() && p.canShowWebcams() && !p.isSourceBlocked(player)) && players.contains(p.getUuid()) && (includeSelf || !p.getUuid().equals(player))));
        }
        finally {
            buf.release();
        }
    }

    public void sendKeepAlives() {
        long time = System.currentTimeMillis();
        long max = (long)this.keepAlivePeriod * 10L;
        ByteBuf unpooledBuf = Unpooled.buffer((int)KeepAlivePacket.INSTANCE.getEstimatedSizeWithId());
        KeepAlivePacket.INSTANCE.encodeWithId(unpooledBuf);
        this.playerStateMap.values().forEach(player -> {
            if (player.isAuthenticated()) {
                if (time - player.getLastKeepAlive() > max) {
                    player.setAuthenticated(false);
                    Webcam.getLogger().info(player.getName() + " timed out");
                } else {
                    this.sendBatching(new S2CEncodedPacket((PlayerState)player, unpooledBuf.retainedDuplicate()));
                }
            }
        });
        this.flushChannel();
    }

    public void close() {
        try {
            this.channel.close().sync();
        }
        catch (Exception e) {
            Webcam.getLogger().error("Failed to close Webcam server channel", e);
        }
        this.keepAliveThread.interrupt();
    }

    public void minecraftTick() {
        if ((long)(this.minecraftTickCount++ % Webcam.getServerConfig().getData().permissionCheckPeriod()) == 0L) {
            WebcamService service = Webcam.getService();
            this.playerStateMap.values().forEach(p -> this.updatePermissions(service, (PlayerState)p));
        }
    }

    private void updatePermissions(WebcamService service, PlayerState player) {
        boolean broadcast = service.checkWebcamBroadcastPermission(player.getUuid());
        boolean view = service.checkWebcamViewPermission(player.getUuid());
        boolean prevBroadcast = player.updateBroadcastPermission(broadcast);
        boolean prevView = player.updateViewPermission(view);
        if (broadcast != prevBroadcast || view != prevView) {
            this.send(player, new PermissionsS2CPacket(broadcast, view));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void channelRead0(ChannelHandlerContext ctx, C2SPacket msg) {
        Packet packet;
        PlayerState sender = msg.sender();
        Packet packet2 = msg.packet();
        if (packet2 instanceof AuthPacket) {
            block24: {
                KnownSourcesS2CPacket addPlayerPacket;
                packet = (AuthPacket)packet2;
                try {
                    UUID uUID;
                    UUID playerUuid = uUID = ((AuthPacket)packet).playerUuid();
                    UUID secret = uUID = ((AuthPacket)packet).secret();
                    if (!playerUuid.equals(sender.getUuid()) || !secret.equals(sender.getSecret())) break block24;
                    if (!sender.isAuthenticated()) {
                        this.updatePermissions(Webcam.getService(), sender);
                        sender.setAuthenticated(true);
                        Webcam.getLogger().info("Successfully authenticated " + sender.getName());
                    } else {
                        Webcam.getLogger().warn(sender.getName() + " sent duplicate auth packet");
                    }
                    addPlayerPacket = new KnownSourcesS2CPacket(List.of(new KnownSource(playerUuid, sender.getName())));
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                ByteBuf addPlayerPacketBuf = ctx.alloc().buffer(addPlayerPacket.getEstimatedSizeWithId());
                try {
                    this.broadcastNoRelease(addPlayerPacketBuf, addPlayerPacket, p -> p != sender);
                }
                finally {
                    addPlayerPacketBuf.release();
                }
                this.sendBatching(sender, new ServerConfigPacket(Webcam.getServerConfig().getData().synced()));
                this.sendBatching(sender, new PermissionsS2CPacket(sender.hasBroadcastPermission(), sender.hasViewPermission()));
                this.sendBatching(sender, AuthAckPacket.INSTANCE);
                this.flushChannel();
                int mtu = Webcam.getServerConfig().getData().synced().mtu();
                Iterator<KnownSource> playerSources = this.playerStateMap.values().stream().filter(PlayerState::isAuthenticated).map(p -> new KnownSource(p.getUuid(), p.getName())).iterator();
                Iterator<KnownSourcesS2CPacket> iterator = KnownSourcesS2CPacket.split(mtu, playerSources).iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.flushChannel();
                        return;
                    }
                    KnownSourcesS2CPacket sourceListPacket = iterator.next();
                    this.sendBatching(sender, sourceListPacket);
                }
            }
            Webcam.getLogger().warn(sender.getName() + " sent invalid auth packet");
            return;
        }
        if (!sender.isAuthenticated()) {
            throw new IllegalStateException(sender.getName() + " sent a packet without authenticating");
        }
        Packet packet3 = packet2;
        Objects.requireNonNull(packet3);
        packet = packet3;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{KeepAlivePacket.class, VideoC2SPacket.class, CloseSourceC2SPacket.class, ShowWebcamsC2SPacket.class, AddBlockedSourceC2SPacket.class, RemoveBlockedSourceC2SPacket.class}, (Object)packet, n)) {
            case 0: {
                KeepAlivePacket ignored = (KeepAlivePacket)packet;
                sender.setLastKeepAlive(System.currentTimeMillis());
                return;
            }
            case 1: {
                VideoC2SPacket videoC2SPacket = (VideoC2SPacket)packet;
                {
                    NalUnit nalUnit;
                    NalUnit nal = nalUnit = videoC2SPacket.nal();
                    if (!sender.hasBroadcastPermission()) {
                        this.send(sender, new PermissionsS2CPacket(false, sender.hasViewPermission()));
                        return;
                    }
                    UUID uuid = sender.getUuid();
                    ServerConfig config = Webcam.getServerConfig().getData();
                    double maxDistance = config.maxDisplayDistance();
                    VideoS2CPacket videoPacket = new VideoS2CPacket(config.displayOnFace() ? new VideoSource.Face(uuid, maxDistance) : new VideoSource.AboveHead(uuid, maxDistance, config.displayShape(), config.displayOffsetY(), config.displaySize(), config.hideNicknames(), null), nal);
                    boolean includeSelf = config.displaySelfWebcam();
                    this.broadcastVideoNearby(uuid, ctx.alloc().buffer(videoPacket.getEstimatedSizeWithId()), videoPacket, maxDistance, includeSelf, false);
                    return;
                }
            }
            case 2: {
                CloseSourceC2SPacket ignored = (CloseSourceC2SPacket)packet;
                UUID uuid = sender.getUuid();
                boolean includeSelf = Webcam.getServerConfig().getData().displaySelfWebcam();
                CloseSourceS2CPacket reply = new CloseSourceS2CPacket(uuid);
                this.broadcastVideoNearby(uuid, ctx.alloc().buffer(reply.getEstimatedSizeWithId()), reply, Webcam.getServerConfig().getData().maxDisplayDistance(), includeSelf, true);
                return;
            }
            case 3: {
                ShowWebcamsC2SPacket showWebcamsC2SPacket = (ShowWebcamsC2SPacket)packet;
                {
                    boolean bl;
                    boolean showWebcams = bl = showWebcamsC2SPacket.showWebcams();
                    sender.setShowWebcams(showWebcams);
                    return;
                }
            }
            case 4: {
                AddBlockedSourceC2SPacket addBlockedSourceC2SPacket = (AddBlockedSourceC2SPacket)packet;
                {
                    UUID uUID;
                    UUID uuid = uUID = addBlockedSourceC2SPacket.uuid();
                    sender.addBlockedSource(uuid);
                    return;
                }
            }
            case 5: {
                RemoveBlockedSourceC2SPacket removeBlockedSourceC2SPacket = (RemoveBlockedSourceC2SPacket)packet;
                {
                    UUID uUID;
                    UUID uuid = uUID = removeBlockedSourceC2SPacket.uuid();
                    sender.removeBlockedSource(uuid);
                    return;
                }
            }
        }
        throw new IllegalStateException("Can't handle packet " + String.valueOf(packet2) + " from " + sender.getName());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (Webcam.isDebugMode()) {
            Webcam.getLogger().warn("Failed to handle packet from client", cause);
        }
    }
}

