/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam;

import java.util.UUID;
import ru.dimaskama.webcam.Webcam;
import ru.dimaskama.webcam.server.WebcamServer;

public class WebcamEvents {
    public static void onMinecraftServerStarted() {
        if (!Webcam.getService().isInReplay()) {
            Webcam.getServerConfig().loadOrCreate();
            WebcamServer.initialize(Webcam.getServerConfig().getData());
        }
    }

    public static void onMinecraftServerTick() {
        WebcamServer server = WebcamServer.getInstance();
        if (server != null) {
            server.minecraftTick();
        }
    }

    public static void onMinecraftServerStopping() {
        WebcamServer.shutdown();
    }

    public static void onPlayerDisconnected(UUID player) {
        WebcamServer server = WebcamServer.getInstance();
        if (server != null) {
            server.disconnectPlayer(player);
        }
    }
}

