/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.util.function.Consumer;

public class VideoPacketBuffer {
    private final Int2ObjectSortedMap<byte[]> buffer = new Int2ObjectAVLTreeMap();
    private final int maxBufferSize;
    private final Consumer<byte[]> packetConsumer;
    private int expectedSequence = -1;

    public VideoPacketBuffer(int maxBufferSize, Consumer<byte[]> packetConsumer) {
        this.maxBufferSize = maxBufferSize;
        this.packetConsumer = packetConsumer;
    }

    public void receivePacket(int sequenceNumber, byte[] packet) {
        if (this.expectedSequence == -1) {
            this.expectedSequence = sequenceNumber;
        } else if (sequenceNumber < this.expectedSequence) {
            return;
        }
        this.buffer.put(sequenceNumber, (Object)packet);
        while (this.buffer.containsKey(this.expectedSequence)) {
            this.packetConsumer.accept((byte[])this.buffer.remove(this.expectedSequence));
            ++this.expectedSequence;
        }
        if (this.buffer.size() > this.maxBufferSize) {
            for (byte[] p : this.buffer.values()) {
                this.packetConsumer.accept(p);
            }
            this.buffer.clear();
            this.expectedSequence = -1;
        }
    }
}

