/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.net;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramPacket;
import java.util.UUID;
import javax.crypto.SecretKey;
import ru.dimaskama.webcam.client.net.WebcamClient;
import ru.dimaskama.webcam.net.Encryption;
import ru.dimaskama.webcam.net.packet.Packet;

public class EncodeEncryptOutboundC2SHandler
extends ChannelOutboundHandlerAdapter {
    private final WebcamClient client;

    public EncodeEncryptOutboundC2SHandler(WebcamClient client) {
        this.client = client;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Packet) {
            byte[] encrypted;
            Packet packet = (Packet)msg;
            ByteBuf encoded = ctx.alloc().buffer(packet.getEstimatedSizeWithId());
            try {
                packet.encodeWithId(encoded);
                SecretKey secretKey = this.client.getSecretKey();
                if (encoded.hasArray()) {
                    encrypted = Encryption.encrypt(encoded.array(), encoded.arrayOffset() + encoded.readerIndex(), encoded.readableBytes(), secretKey);
                } else {
                    byte[] array = new byte[encoded.readableBytes()];
                    encoded.readBytes(array);
                    encrypted = Encryption.encrypt(array, 0, array.length, secretKey);
                }
            }
            catch (Exception e) {
                encoded.release();
                throw e;
            }
            UUID uuid = this.client.getPlayerUuid();
            ByteBuf buf = ctx.alloc().buffer(17 + encrypted.length);
            try {
                buf.writeByte(-52).writeLong(uuid.getMostSignificantBits()).writeLong(uuid.getLeastSignificantBits()).writeBytes(encrypted);
                ctx.write((Object)new DatagramPacket(buf, this.client.getServerAddress()));
            }
            catch (Exception e) {
                buf.release();
                throw e;
            }
        }
        ctx.write(msg);
    }
}

