/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.screen;

import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import ru.dimaskama.webcam.Webcam;
import ru.dimaskama.webcam.WebcamMod;
import ru.dimaskama.webcam.client.WebcamModClient;
import ru.dimaskama.webcam.client.cap.Capturing;
import ru.dimaskama.webcam.client.cap.DeviceException;
import ru.dimaskama.webcam.client.cap.DeviceOutputListener;
import ru.dimaskama.webcam.client.cap.ImageUtil;
import ru.dimaskama.webcam.client.config.ClientConfig;
import ru.dimaskama.webcam.client.config.Resolution;
import ru.dimaskama.webcam.client.net.WebcamClient;
import ru.dimaskama.webcam.client.screen.widget.ClampedIntSlider;
import ru.dimaskama.webcam.client.screen.widget.DeviceSelectButton;
import ru.dimaskama.webcam.client.screen.widget.OnOffButton;
import ru.dimaskama.webcam.client.screen.widget.PlayersWebcamsButton;
import ru.dimaskama.webcam.client.screen.widget.ResolutionSelectButton;
import ru.dimaskama.webcam.client.screen.widget.StatusWidget;
import ru.dimaskama.webcam.client.screen.widget.UpdateDevicesButton;
import ru.dimaskama.webcam.net.packet.CloseSourceC2SPacket;
import ru.dimaskama.webcam.net.packet.ShowWebcamsC2SPacket;

public class WebcamScreen
extends class_437
implements DeviceOutputListener {
    public static final class_2960 BACKGROUND_SPRITE = WebcamMod.id("background");
    private static final class_2960 PREVIEW_TEXTURE = WebcamMod.id("webcam_preview");
    private static final int BUTTON_WIDTH = 152;
    private static final int MENU_HEIGHT = 167;
    private static final int PREVIEW_DIM = 142;
    private static boolean showPreview = true;
    private static int previewTextureDeviceIndex;
    private static class_1043 previewTexture;
    private final class_437 parent;
    private final boolean notFromGame;
    private boolean firstInit = true;
    private boolean addedToWebcamListeners;
    private boolean configDirty;
    private int selectedDevice;
    private Resolution resolution;
    private int fps;
    private boolean showIcons;
    private int menuWidth;
    private int menuX;
    private int menuY;
    private class_2561 errorMessage;
    private long errorMessageTime;

    public WebcamScreen(class_437 parent) {
        this(parent, true);
    }

    public WebcamScreen(class_437 parent, boolean notFromGame) {
        super((class_2561)class_2561.method_43471((String)"webcam.screen.webcam"));
        this.parent = parent;
        this.notFromGame = notFromGame;
    }

    @Override
    public int getSelectedDevice() {
        return this.selectedDevice;
    }

    @Override
    @Nullable
    public Resolution getResolution() {
        return this.resolution;
    }

    @Override
    public int getFps() {
        return this.fps;
    }

    @Override
    public int getImageDimension() {
        return -1;
    }

    @Override
    public boolean isListeningFrames() {
        return showPreview || WebcamModClient.CONFIG.getData().webcamEnabled();
    }

    @Override
    public void onFrame(int deviceNumber, int fps, int width, int height, byte[] rgba) {
        class_310.method_1551().execute(() -> {
            block5: {
                try {
                    if (deviceNumber == this.selectedDevice) {
                        previewTextureDeviceIndex = this.selectedDevice;
                        class_1011 prevImage = previewTexture != null ? previewTexture.method_4525() : null;
                        class_1011 newImage = ImageUtil.createNativeImage(prevImage, width, height, rgba);
                        if (newImage != prevImage) {
                            previewTexture = new class_1043(() -> ((class_2960)PREVIEW_TEXTURE).method_12832(), newImage);
                            previewTexture.method_4527(true, false);
                            this.field_22787.method_1531().method_4616(PREVIEW_TEXTURE, (class_1044)previewTexture);
                        } else {
                            previewTexture.method_4524();
                        }
                    }
                }
                catch (Exception e) {
                    if (!Webcam.isDebugMode()) break block5;
                    Webcam.getLogger().warn("Preview error", e);
                }
            }
        });
    }

    @Override
    public void onError(DeviceException e) {
        this.errorMessage = e.getText();
        this.errorMessageTime = System.currentTimeMillis();
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    protected void method_25426() {
        if (!this.addedToWebcamListeners) {
            this.addedToWebcamListeners = true;
            Capturing.addListener(this);
        }
        ClientConfig config = WebcamModClient.CONFIG.getData();
        if (this.firstInit) {
            this.firstInit = false;
            this.selectedDevice = config.selectedDevice();
            this.resolution = config.webcamResolution();
            this.fps = config.webcamFps();
            this.showIcons = config.showIcons();
        }
        this.menuWidth = 160 + (showPreview ? 144 : 0);
        this.menuX = this.field_22789 - this.menuWidth >> 1;
        this.menuY = this.field_22790 - 167 >> 1;
        int buttonY = this.menuY + 21;
        this.method_37063((class_364)new OnOffButton(this.menuX + 4, buttonY, 152, 16, "webcam.screen.webcam.show_webcams", config.showWebcams(), b -> this.updateAndSetConfig(WebcamModClient.CONFIG.getData().withShowWebcams(b))));
        this.method_37063((class_364)new OnOffButton(this.menuX + 4, buttonY += 18, 152, 16, "webcam.screen.webcam.webcam_enabled", config.webcamEnabled(), b -> this.updateAndSetConfig(WebcamModClient.CONFIG.getData().withWebcamEnabled(b))));
        this.method_37063((class_364)new DeviceSelectButton(this.menuX + 4, buttonY += 18, 135, 16, this.selectedDevice, i -> {
            this.selectedDevice = i;
        }));
        this.method_37063((class_364)new UpdateDevicesButton(this.menuX + 152 - 12, buttonY, 16, 16));
        this.method_37063((class_364)new ResolutionSelectButton(this.menuX + 4, buttonY += 18, 152, 16, this.resolution, r -> {
            this.resolution = r;
        }));
        ((ClampedIntSlider)this.method_37063((class_364)new ClampedIntSlider(this.menuX + 4, buttonY += 18, 152, 16, "webcam.screen.webcam.fps", 5, 60, this.fps, i -> {
            this.fps = i;
        }))).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"webcam.screen.webcam.fps.tooltip")));
        this.method_37063((class_364)new OnOffButton(this.menuX + 4, buttonY += 18, 152, 16, "webcam.screen.webcam.show_icons", this.showIcons, b -> {
            this.showIcons = b;
        }));
        this.method_37063((class_364)new OnOffButton(this.menuX + 4, buttonY += 18, 152, 16, "webcam.screen.webcam.show_preview", showPreview, b -> {
            showPreview = b;
            this.method_41843();
        }));
        class_4185 advanced = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"webcam.screen.webcam.advanced"), button -> {
            if (this.parent != null && this.notFromGame) {
                this.field_22787.method_1507(this.parent);
            } else {
                this.field_22787.method_1507(WebcamModClient.getService().createAdvancedConfigScreen(this));
            }
        }).method_46434(this.menuX + 4, buttonY += 18, 152, 16).method_46431());
        if (!WebcamModClient.canUseAdvancedConfigScreen()) {
            advanced.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"webcam.screen.webcam.advanced.not_available")));
            advanced.field_22763 = false;
        }
        this.method_37063((class_364)new StatusWidget(this.menuX + 4, this.menuY + 4, 16, 16));
        this.method_37063((class_364)new PlayersWebcamsButton(this.menuX + this.menuWidth - 20, this.menuY + 4, 16, 16));
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        super.method_25420(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.method_52706(class_10799.field_56883, BACKGROUND_SPRITE, this.menuX, this.menuY, this.menuWidth, 167);
        guiGraphics.method_51439(this.field_22793, this.field_22785, this.field_22789 - this.field_22793.method_27525((class_5348)this.field_22785) >> 1, this.menuY + 7, -11184811, false);
        if (this.errorMessage != null && System.currentTimeMillis() - this.errorMessageTime <= 4000L) {
            guiGraphics.method_27534(this.field_22793, this.errorMessage, this.field_22789 >> 1, this.menuY + 167 + 10, -43691);
        }
        if (showPreview && previewTexture != null && this.selectedDevice == previewTextureDeviceIndex && Capturing.isCapturing(this.selectedDevice)) {
            guiGraphics.method_25290(class_10799.field_56883, PREVIEW_TEXTURE, this.menuX + this.menuWidth - 142 - 4, this.menuY + 21, 0.0f, 0.0f, 142, 142, 142, 142);
        }
    }

    public boolean method_25421() {
        return this.notFromGame;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void method_25432() {
        ClientConfig oldConfig = WebcamModClient.CONFIG.getData();
        ClientConfig newConfig = new ClientConfig(oldConfig.showWebcams(), oldConfig.webcamEnabled(), this.selectedDevice, this.resolution, this.fps, this.showIcons, oldConfig.maxDevices(), oldConfig.packetBufferSize(), oldConfig.maxBitrate(), oldConfig.hud());
        if (this.configDirty || !newConfig.equals(oldConfig)) {
            this.configDirty = false;
            this.updateConfig(oldConfig, newConfig);
            WebcamModClient.CONFIG.setData(newConfig);
            WebcamModClient.CONFIG.save();
        }
        Capturing.removeListener(this);
        this.addedToWebcamListeners = false;
    }

    private void updateConfig(ClientConfig oldConfig, ClientConfig newConfig) {
        WebcamClient webcamClient;
        if (oldConfig.webcamEnabled() && !newConfig.webcamEnabled() && (webcamClient = WebcamClient.getInstance()) != null && webcamClient.isAuthenticated()) {
            webcamClient.send(CloseSourceC2SPacket.INSTANCE);
        }
        if (oldConfig.showWebcams() != newConfig.showWebcams() && (webcamClient = WebcamClient.getInstance()) != null && webcamClient.isAuthenticated()) {
            webcamClient.send(new ShowWebcamsC2SPacket(newConfig.showWebcams()));
        }
    }

    private void updateAndSetConfig(ClientConfig newConfig) {
        ClientConfig oldConfig = WebcamModClient.CONFIG.getData();
        if (!oldConfig.equals(newConfig)) {
            WebcamModClient.CONFIG.setData(newConfig);
            this.configDirty = true;
            this.updateConfig(oldConfig, newConfig);
        }
    }
}

