/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client.screen.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_634;
import net.minecraft.class_6379;
import net.minecraft.class_640;
import net.minecraft.class_7532;
import net.minecraft.class_8685;
import ru.dimaskama.webcam.WebcamMod;
import ru.dimaskama.webcam.client.DisplayingVideoManager;
import ru.dimaskama.webcam.client.KnownSourceClient;
import ru.dimaskama.webcam.client.KnownSourceManager;
import ru.dimaskama.webcam.client.WebcamModClient;
import ru.dimaskama.webcam.client.config.BlockedSources;
import ru.dimaskama.webcam.client.net.WebcamClient;
import ru.dimaskama.webcam.client.screen.widget.HideWebcamButton;
import ru.dimaskama.webcam.net.packet.AddBlockedSourceC2SPacket;
import ru.dimaskama.webcam.net.packet.RemoveBlockedSourceC2SPacket;

public class PlayersWebcamsList
extends class_4265<Entry> {
    private final Runnable dirtyAction;
    private final int rowWidth;
    private Predicate<KnownSourceClient> filter;
    private boolean shouldRefresh;

    public PlayersWebcamsList(class_310 minecraft, Runnable dirtyAction, int rowWidth) {
        super(minecraft, 0, 0, 0, 36);
        this.dirtyAction = dirtyAction;
        this.rowWidth = rowWidth;
    }

    public void refresh(Predicate<KnownSourceClient> filter) {
        this.filter = filter;
        this.shouldRefresh = true;
    }

    public void method_48579(class_332 guiGraphics, int i, int j, float f) {
        if (this.shouldRefresh) {
            this.shouldRefresh = false;
            this.method_25339();
            BlockedSources blocked = WebcamModClient.BLOCKED_SOURCES.getData();
            ArrayList allSources = new ArrayList();
            blocked.sources().forEach((uuid, name) -> {
                KnownSourceClient sourceOnServer = KnownSourceManager.INSTANCE.get((UUID)uuid);
                allSources.add(sourceOnServer != null ? sourceOnServer : new KnownSourceClient((UUID)uuid, (String)name));
            });
            KnownSourceManager.INSTANCE.forEach(source -> {
                if (!blocked.contains(source.getUuid())) {
                    allSources.add(source);
                }
            });
            for (KnownSourceClient source2 : allSources) {
                if (!this.filter.test(source2)) continue;
                this.method_25321((class_350.class_351)new Entry(source2, blocked.contains(source2.getUuid())));
            }
        }
        super.method_48579(guiGraphics, i, j, f);
    }

    public int method_25322() {
        return this.rowWidth;
    }

    public class Entry
    extends class_4265.class_4266<Entry> {
        private static final class_2960 UNKNOWN_SPRITE = WebcamMod.id("unknown");
        private final KnownSourceClient source;
        private final List<class_339> children = new ArrayList<class_339>();
        private final HideWebcamButton hideButton;

        public Entry(KnownSourceClient source, boolean blocked) {
            this.source = source;
            this.hideButton = new HideWebcamButton(blocked, b -> {
                WebcamClient client = WebcamClient.getInstance();
                if (b) {
                    WebcamModClient.BLOCKED_SOURCES.getData().add(source.getUuid(), source.getName());
                    DisplayingVideoManager.INSTANCE.remove(source.getUuid());
                    if (client != null && client.isAuthenticated()) {
                        client.send(new AddBlockedSourceC2SPacket(source.getUuid()));
                    }
                } else {
                    WebcamModClient.BLOCKED_SOURCES.getData().remove(source.getUuid());
                    if (client != null && client.isAuthenticated()) {
                        client.send(new RemoveBlockedSourceC2SPacket(source.getUuid()));
                    }
                }
                if (!PlayersWebcamsList.this.filter.test(source)) {
                    PlayersWebcamsList.this.method_25330((class_350.class_351)this);
                }
                PlayersWebcamsList.this.dirtyAction.run();
            });
            this.children.add((class_339)this.hideButton);
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            int x = this.method_46426() + 2;
            int y = this.method_46427();
            int entryWidth = this.method_25368();
            int entryHeight = this.method_25364() - 4;
            guiGraphics.method_25294(x, y, x + entryWidth - 4, y + entryHeight, 0x33000000);
            class_2960 customIcon = this.source.getCustomIcon();
            if (customIcon != null) {
                guiGraphics.method_25290(class_10799.field_56883, customIcon, x, y, 0.0f, 0.0f, 32, 32, 32, 32);
            } else {
                class_8685 skin;
                class_634 connection = class_310.method_1551().method_1562();
                class_640 playerInfo = connection != null ? connection.method_2871(this.source.getUuid()) : null;
                class_8685 class_86852 = skin = playerInfo != null ? playerInfo.method_52810() : null;
                if (skin != null) {
                    class_7532.method_52722((class_332)guiGraphics, (class_8685)skin, (int)x, (int)y, (int)32);
                } else {
                    guiGraphics.method_52706(class_10799.field_56883, UNKNOWN_SPRITE, x, y, 32, 32);
                }
            }
            guiGraphics.method_25303(class_310.method_1551().field_1772, this.source.getName(), x + 36, y + 4, -1);
            this.hideButton.method_55444(20, 20, x + entryWidth - 4 - 22, y + (entryHeight - 20 >> 1));
            this.hideButton.method_25394(guiGraphics, mouseX, mouseY, deltaTicks);
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }
    }
}

