/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;

public enum VideoDisplayShape {
    SQUARE("square", 0),
    ROUND("round", 1);

    public static final Codec<VideoDisplayShape> CODEC;
    public final String key;
    public final byte code;

    private VideoDisplayShape(String key, byte code) {
        this.key = key;
        this.code = code;
    }

    public static VideoDisplayShape byCode(byte code) {
        for (VideoDisplayShape type : VideoDisplayShape.values()) {
            if (type.code != code) continue;
            return type;
        }
        throw new IllegalArgumentException("Invalid code: " + Integer.toBinaryString(code));
    }

    public static VideoDisplayShape byKey(String key) {
        for (VideoDisplayShape type : VideoDisplayShape.values()) {
            if (!type.key.equalsIgnoreCase(key)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown shape: " + key);
    }

    public String toString() {
        return this.key;
    }

    static {
        CODEC = Codec.STRING.comapFlatMap(str -> {
            for (VideoDisplayShape shape : VideoDisplayShape.values()) {
                if (!str.equalsIgnoreCase(shape.key)) continue;
                return DataResult.success((Object)((Object)shape));
            }
            return DataResult.error(() -> "Unknown shape: " + str);
        }, shape -> shape.key);
    }
}

