/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.fabric;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import ru.dimaskama.webcam.WebcamEvents;
import ru.dimaskama.webcam.WebcamMod;
import ru.dimaskama.webcam.WebcamModService;
import ru.dimaskama.webcam.WebcamService;
import ru.dimaskama.webcam.client.fabric.compat.replay.ReplaysCompat;
import ru.dimaskama.webcam.command.WebcamconfigModCommand;
import ru.dimaskama.webcam.fabric.WebcamFabricMessaging;
import ru.dimaskama.webcam.message.Channel;
import ru.dimaskama.webcam.message.Message;
import ru.dimaskama.webcam.message.ServerMessaging;

public class WebcamFabric
implements ModInitializer {
    public static final ModContainer MOD_CONTAINER = (ModContainer)FabricLoader.getInstance().getModContainer("webcam").orElseThrow();
    private static MinecraftServer server;

    public void onInitialize() {
        WebcamMod.init(MOD_CONTAINER.getMetadata().getVersion().toString(), FabricLoader.getInstance().getConfigDir().resolve("webcam"), new WebcamService(this){

            @Override
            public <T extends Message> void registerChannel(Channel<T> channel, @Nullable ServerMessaging.ServerHandler<T> handler) {
                WebcamFabricMessaging.register(channel, handler);
            }

            @Override
            public void sendToPlayer(UUID player, Message message) {
                class_3222 serverPlayer;
                MinecraftServer server = WebcamFabric.server;
                if (server != null && (serverPlayer = server.method_3760().method_14602(player)) != null) {
                    WebcamFabricMessaging.sendToPlayer(serverPlayer, message);
                }
            }

            @Override
            public void sendSystemMessage(UUID player, String message) {
                MinecraftServer server = WebcamFabric.server;
                if (server != null) {
                    server.execute(() -> {
                        class_3222 serverPlayer = server.method_3760().method_14602(player);
                        if (serverPlayer != null) {
                            serverPlayer.method_64398((class_2561)class_2561.method_43470((String)message));
                        }
                    });
                }
            }

            @Override
            public void acceptForNearbyPlayers(UUID playerUuid, double maxDistance, Consumer<Set<UUID>> action) {
                class_3222 player;
                MinecraftServer server = WebcamFabric.server;
                if (server != null && (player = server.method_3760().method_14602(playerUuid)) != null) {
                    HashSet<UUID> players = new HashSet<UUID>();
                    players.add(player.method_5667());
                    try {
                        ArrayList levelPlayers = new ArrayList(player.method_51469().method_18456());
                        class_243 pos = player.method_73189();
                        double maxDistanceSqr = maxDistance * maxDistance;
                        for (class_1657 levelPlayer : levelPlayers) {
                            if (!(levelPlayer.method_73189().method_1025(pos) <= maxDistanceSqr)) continue;
                            players.add(levelPlayer.method_5667());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    action.accept(players);
                }
            }

            @Override
            public boolean checkWebcamBroadcastPermission(UUID playerUuid) {
                class_3222 player;
                MinecraftServer server = WebcamFabric.server;
                if (server != null && (player = server.method_3760().method_14602(playerUuid)) != null) {
                    return Permissions.check((class_1297)player, (String)"webcam.broadcast", (boolean)true);
                }
                return true;
            }

            @Override
            public boolean checkWebcamViewPermission(UUID playerUuid) {
                class_3222 player;
                MinecraftServer server = WebcamFabric.server;
                if (server != null && (player = server.method_3760().method_14602(playerUuid)) != null) {
                    return Permissions.check((class_1297)player, (String)"webcam.view", (boolean)true);
                }
                return true;
            }

            @Override
            public boolean isInReplay() {
                return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && ReplaysCompat.isInReplay();
            }
        }, new WebcamModService(this){

            @Override
            public boolean isModLoaded(String modId) {
                return FabricLoader.getInstance().isModLoaded(modId);
            }

            @Override
            public boolean checkWebcamconfigCommandPermission(class_2168 commandSource) {
                return Permissions.check((class_2172)commandSource, (String)"webcam.command.config", (int)2);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            WebcamFabric.server = server;
            WebcamEvents.onMinecraftServerStarted();
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> WebcamEvents.onMinecraftServerTick());
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            WebcamEvents.onMinecraftServerStopping();
            WebcamFabric.server = null;
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> WebcamEvents.onPlayerDisconnected(handler.method_32311().method_5667()));
        CommandRegistrationCallback.EVENT.register((dispatcher, r, e) -> WebcamconfigModCommand.register((CommandDispatcher<class_2168>)dispatcher));
    }
}

