/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.net;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.annotation.Nullable;

public final class KnownSource {
    public static final int ICON_DIMENSION = 16;
    public static final int ICON_SIZE = 1024;
    private final UUID uuid;
    private final String name;
    @Nullable
    private final byte[] customIcon;
    private byte[] nameBytesCache;

    public KnownSource(UUID uuid, String name) {
        this(uuid, name, null);
    }

    public KnownSource(UUID uuid, String name, @Nullable byte[] customIcon) {
        this.uuid = uuid;
        this.name = name;
        if (customIcon != null && customIcon.length != 1024) {
            throw new IllegalArgumentException("customIcon must be a 16x16 raw RGBA image with size 1024");
        }
        this.customIcon = customIcon;
    }

    public KnownSource(ByteBuf buf) {
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        byte nameLength = buf.readByte();
        byte[] nameBytes = new byte[nameLength];
        buf.readBytes(nameBytes);
        this.name = new String(nameBytes, StandardCharsets.UTF_8);
        byte[] customIcon = null;
        if (buf.readBoolean()) {
            customIcon = new byte[1024];
            buf.readBytes(customIcon);
        }
        this.customIcon = customIcon;
    }

    public void writeBytes(ByteBuf buf) {
        buf.writeLong(this.uuid.getMostSignificantBits()).writeLong(this.uuid.getLeastSignificantBits());
        byte[] nameBytes = this.getNameBytes();
        buf.writeByte(nameBytes.length).writeBytes(nameBytes);
        buf.writeBoolean(this.customIcon != null);
        if (this.customIcon != null) {
            buf.writeBytes(this.customIcon);
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public byte[] getCustomIcon() {
        return this.customIcon;
    }

    private byte[] getNameBytes() {
        if (this.nameBytesCache == null) {
            this.nameBytesCache = this.name.getBytes(StandardCharsets.UTF_8);
        }
        return this.nameBytesCache;
    }

    public int getSize() {
        return 18 + this.getNameBytes().length + (this.customIcon != null ? 1024 : 0);
    }
}

