/*
 * Decompiled with CFR 0.152.
 */
package net.neganote.gtutilities.common.item;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class OmniBreakerItem
extends ComponentItem {
    protected int tier;

    protected OmniBreakerItem(Item.Properties properties, int tier) {
        super(properties);
        this.tier = tier;
    }

    public static OmniBreakerItem create(Item.Properties properties, int tier) {
        return new OmniBreakerItem(properties, tier);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        IElectricItem electricItem = Objects.requireNonNull(GTCapabilityHelper.getElectricItem((ItemStack)stack));
        return electricItem.getCharge() >= GTValues.VEX[this.tier];
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        IElectricItem electricItem = Objects.requireNonNull(GTCapabilityHelper.getElectricItem((ItemStack)pStack));
        if (electricItem.getCharge() >= GTValues.VEX[this.tier]) {
            return 100000.0f;
        }
        return 0.0f;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pMiningEntity) {
        super.m_6813_(pStack, pLevel, pState, pPos, pMiningEntity);
        IElectricItem electricItem = Objects.requireNonNull(GTCapabilityHelper.getElectricItem((ItemStack)pStack));
        Integer unbreaking = this.getAllEnchantments(pStack).getOrDefault(Enchantments.f_44986_, 0);
        double chance = 1.0f / (float)(unbreaking + 1);
        double rand = Math.random();
        if (electricItem.getCharge() >= GTValues.VEX[this.tier]) {
            if (rand <= chance) {
                electricItem.discharge(GTValues.VEX[this.tier], this.tier, true, false, false);
            }
            return true;
        }
        return false;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 22;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44986_;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return super.isBookEnchantable(stack, book);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.omnibreaker.modern_vajra"));
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.omnibreaker.can_break_anything").m_130940_(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.omnibreaker.right_click_function").m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }
}

