/*
 * Decompiled with CFR 0.152.
 */
package net.neganote.gtutilities.common.machine.multiblock;

import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.error.PatternError;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTRecipeCapabilities;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neganote.gtutilities.common.materials.UtilMaterials;
import net.neganote.gtutilities.config.UtilConfig;
import net.neganote.gtutilities.saveddata.PTERBSavedData;
import net.neganote.gtutilities.utils.EnergyUtils;
import org.jetbrains.annotations.NotNull;

public class PTERBMachine
extends WorkableElectricMultiblockMachine
implements IControllable,
IExplosionMachine,
IFancyUIMachine,
IDisplayUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PTERBMachine.class, WorkableElectricMultiblockMachine.MANAGED_FIELD_HOLDER);
    private List<IMultiPart> localPowerOutput = new ArrayList<IMultiPart>();
    private List<IMultiPart> localPowerInput = new ArrayList<IMultiPart>();
    protected ConditionalSubscriptionHandler converterSubscription = new ConditionalSubscriptionHandler((ITickSubscription)this, this::convertEnergyTick, this::isSubscriptionActive);
    private int coolantDrain;
    @Persisted
    @DescSynced
    private int frequency = 0;
    @Persisted
    @DescSynced
    private int coolantTimer = 0;

    public PTERBMachine(IMachineBlockEntity holder) {
        super(holder, new Object[0]);
    }

    public void explode() {
        this.removeWirelessEnergy();
        long inputVoltage = 0L;
        long outputVoltage = 0L;
        if (!this.localPowerInput.isEmpty()) {
            EnergyContainerList localInputs = EnergyUtils.getEnergyListFromMultiParts(this.localPowerInput);
            inputVoltage = localInputs.getInputVoltage();
        }
        if (!this.localPowerOutput.isEmpty()) {
            EnergyContainerList localOutputs = EnergyUtils.getEnergyListFromMultiParts(this.localPowerOutput);
            outputVoltage = localOutputs.getOutputVoltage();
        }
        long tier = Math.max(GTUtil.getFloorTierByVoltage((long)inputVoltage), GTUtil.getFloorTierByVoltage((long)outputVoltage));
        this.doExplosion(15.0f + (float)tier);
    }

    public void convertEnergyTick() {
        Object left;
        if (this.frequency == 0) {
            this.getRecipeLogic().setStatus(RecipeLogic.Status.SUSPEND);
            return;
        }
        if (this.isWorkingEnabled()) {
            this.getRecipeLogic().setStatus(this.isSubscriptionActive() ? RecipeLogic.Status.WORKING : RecipeLogic.Status.SUSPEND);
        }
        if (this.isWorkingEnabled() && this.getRecipeLogic().getStatus() == RecipeLogic.Status.WORKING && UtilConfig.coolantEnabled() && this.coolantTimer == 0 && this.frequency != 0) {
            NotifiableFluidTank tank;
            List<NotifiableFluidTank> coolantTanks = this.getCapabilitiesFlat(IO.IN, GTRecipeCapabilities.FLUID).stream().map(NotifiableFluidTank.class::cast).toList();
            left = List.of(FluidIngredient.of((Fluid)UtilMaterials.QuantumCoolant.getFluid(), (int)this.coolantDrain));
            Iterator<NotifiableFluidTank> iterator = coolantTanks.iterator();
            while (iterator.hasNext() && (left = (tank = iterator.next()).handleRecipe(IO.IN, null, (List)left, false)) != null) {
            }
            if (left != null && !left.isEmpty()) {
                if (!ConfigHolder.INSTANCE.machines.harmlessActiveTransformers) {
                    this.explode();
                } else {
                    this.coolantTimer = 0;
                    this.getRecipeLogic().setStatus(RecipeLogic.Status.SUSPEND);
                    this.converterSubscription.updateSubscription();
                    return;
                }
            }
        }
        if (this.isWorkingEnabled() && this.getRecipeLogic().getStatus() == RecipeLogic.Status.WORKING) {
            this.coolantTimer = (this.coolantTimer + 1) % 20;
        }
        if (this.isWorkingEnabled() && this.frequency != 0 && (left = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)left;
            PTERBSavedData savedData = PTERBSavedData.getOrCreate(serverLevel.m_7654_().m_129783_());
            EnergyContainerList powerInput = savedData.getWirelessEnergyInputs(this.frequency);
            EnergyContainerList powerOutput = savedData.getWirelessEnergyOutputs(this.frequency);
            long canDrain = powerInput.getEnergyStored();
            long totalDrained = powerOutput.changeEnergy(canDrain);
            powerInput.removeEnergy(totalDrained);
        }
        this.converterSubscription.updateSubscription();
    }

    private int calculateCoolantDrain() {
        long scalingFactor;
        int coolantDrain;
        long inputAmperage = 0L;
        long inputVoltage = 0L;
        long outputAmperage = 0L;
        long outputVoltage = 0L;
        if (!this.localPowerInput.isEmpty()) {
            EnergyContainerList localInputs = EnergyUtils.getEnergyListFromMultiParts(this.localPowerInput);
            inputAmperage = localInputs.getInputAmperage();
            inputVoltage = localInputs.getInputVoltage();
        }
        if (!this.localPowerOutput.isEmpty()) {
            EnergyContainerList localOutputs = EnergyUtils.getEnergyListFromMultiParts(this.localPowerOutput);
            outputAmperage = localOutputs.getOutputAmperage();
            outputVoltage = localOutputs.getOutputVoltage();
        }
        if ((coolantDrain = UtilConfig.INSTANCE.features.pterbCoolantBaseDrain + (int)((float)(scalingFactor = Math.max(inputAmperage * inputVoltage, outputAmperage * outputVoltage)) * UtilConfig.INSTANCE.features.pterbCoolantIOMultiplier)) <= 0) {
            coolantDrain = 1;
        }
        return coolantDrain;
    }

    protected boolean isSubscriptionActive() {
        if (!this.isFormed()) {
            return false;
        }
        if (this.localPowerInput == null) {
            return false;
        }
        return this.localPowerOutput != null;
    }

    public boolean onWorking() {
        return super.onWorking();
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        if (this.frequency == 0) {
            this.setWorkingEnabled(false);
        }
        ArrayList<IMultiPart> localPowerInput = new ArrayList<IMultiPart>();
        ArrayList<IMultiPart> localPowerOutput = new ArrayList<IMultiPart>();
        Map ioMap = (Map)this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getPrioritySortedParts()) {
            IO io = ioMap.getOrDefault(part.self().getPos().m_121878_(), IO.BOTH);
            if (io == IO.NONE) continue;
            for (RecipeHandlerList handlerList : part.getRecipeHandlers()) {
                List<IEnergyContainer> energyContainers;
                IO handlerIO = handlerList.getHandlerIO();
                if (io != IO.BOTH && handlerIO != IO.BOTH && io != handlerIO || (energyContainers = handlerList.getCapability((RecipeCapability)EURecipeCapability.CAP).stream().filter(IEnergyContainer.class::isInstance).map(IEnergyContainer.class::cast).toList()).isEmpty()) continue;
                if (handlerIO == IO.IN) {
                    localPowerInput.add(part);
                    continue;
                }
                if (handlerIO != IO.OUT) continue;
                localPowerOutput.add(part);
            }
        }
        if (localPowerInput.isEmpty() && localPowerOutput.isEmpty()) {
            this.onStructureInvalid();
            this.getMultiblockState().setError(new PatternError());
            return;
        }
        this.localPowerInput = localPowerInput;
        this.localPowerOutput = localPowerOutput;
        this.coolantDrain = this.calculateCoolantDrain();
        if (this.frequency != 0 && this.isActive()) {
            this.addWirelessEnergy();
        }
        this.converterSubscription.updateSubscription();
    }

    @NotNull
    private List<IMultiPart> getPrioritySortedParts() {
        return this.getParts().stream().sorted(Comparator.comparing(part -> {
            if (part instanceof MetaMachine) {
                MetaMachine partMachine = (MetaMachine)part;
                Block partBlock = partMachine.getBlockState().m_60734_();
                if (PartAbility.OUTPUT_ENERGY.isApplicable(partBlock)) {
                    return 1;
                }
                if (PartAbility.SUBSTATION_OUTPUT_ENERGY.isApplicable(partBlock)) {
                    return 2;
                }
                if (PartAbility.OUTPUT_LASER.isApplicable(partBlock)) {
                    return 3;
                }
            }
            return 4;
        })).toList();
    }

    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onStructureInvalid() {
        this.coolantTimer = 0;
        this.removeWirelessEnergy();
        if (this.isWorkingEnabled() && this.recipeLogic.getStatus() == RecipeLogic.Status.WORKING && !ConfigHolder.INSTANCE.machines.harmlessActiveTransformers) {
            this.explode();
        }
        super.onStructureInvalid();
        this.localPowerOutput = new ArrayList<IMultiPart>();
        this.localPowerInput = new ArrayList<IMultiPart>();
        this.setWorkingEnabled(false);
        this.converterSubscription.unsubscribe();
    }

    private void removeWirelessEnergy() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PTERBSavedData savedData = PTERBSavedData.getOrCreate(serverLevel.m_7654_().m_129783_());
            savedData.removeEnergyInputs(this.frequency, this.localPowerInput);
            savedData.removeEnergyOutputs(this.frequency, this.localPowerOutput);
            savedData.saveDataToCache();
        }
    }

    private void addWirelessEnergy() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PTERBSavedData savedData = PTERBSavedData.getOrCreate(serverLevel.m_7654_().m_129783_());
            savedData.addEnergyInputs(this.frequency, this.localPowerInput);
            savedData.addEnergyOutputs(this.frequency, this.localPowerOutput);
            savedData.saveDataToCache();
        }
    }

    public static TraceabilityPredicate getHatchPredicates() {
        TraceabilityPredicate predicate = Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_ENERGY}).setPreviewCount(1).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_ENERGY}).setPreviewCount(2)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.SUBSTATION_INPUT_ENERGY}).setPreviewCount(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.SUBSTATION_OUTPUT_ENERGY}).setPreviewCount(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_LASER}).setPreviewCount(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_LASER}).setPreviewCount(1));
        if (UtilConfig.coolantEnabled()) {
            predicate = predicate.or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.IMPORT_FLUIDS}).setExactLimit(1));
        }
        return predicate;
    }

    public void addDisplayText(@NotNull List<Component> textList) {
        if (this.isFormed()) {
            if (this.frequency == 0) {
                textList.add((Component)Component.m_237115_((String)"gtmutils.pterb_machine.invalid_frequency").m_130940_(ChatFormatting.RED));
                return;
            }
            if (!this.isWorkingEnabled()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.work_paused"));
            } else if (this.isActive()) {
                long inputAmperage = 0L;
                long inputVoltage = 0L;
                long outputAmperage = 0L;
                long outputVoltage = 0L;
                if (!this.localPowerInput.isEmpty()) {
                    EnergyContainerList localInputs = EnergyUtils.getEnergyListFromMultiParts(this.localPowerInput);
                    inputAmperage = localInputs.getInputAmperage();
                    inputVoltage = localInputs.getInputVoltage();
                }
                if (!this.localPowerOutput.isEmpty()) {
                    EnergyContainerList localOutputs = EnergyUtils.getEnergyListFromMultiParts(this.localPowerOutput);
                    outputAmperage = localOutputs.getOutputAmperage();
                    outputVoltage = localOutputs.getOutputVoltage();
                }
                long inputTotal = inputVoltage * inputAmperage;
                long outputTotal = outputVoltage * outputAmperage;
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.running"));
                if (inputTotal > 0L) {
                    textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.active_transformer.max_input", (Object[])new Object[]{FormattingUtil.formatNumbers((long)Math.abs(inputTotal))}));
                }
                if (outputTotal > 0L) {
                    textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.active_transformer.max_output", (Object[])new Object[]{FormattingUtil.formatNumbers((long)Math.abs(outputTotal))}));
                }
                if (UtilConfig.coolantEnabled()) {
                    textList.add((Component)Component.m_237110_((String)"gtmutils.multiblock.pterb_machine.coolant_usage", (Object[])new Object[]{FormattingUtil.formatNumbers((int)this.coolantDrain), UtilMaterials.QuantumCoolant.getLocalizedName()}));
                }
                if (!ConfigHolder.INSTANCE.machines.harmlessActiveTransformers) {
                    textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.active_transformer.danger_enabled"));
                }
            } else {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.idling"));
            }
        }
    }

    public void setFrequencyFromString(String str) {
        this.removeWirelessEnergy();
        this.frequency = Integer.parseInt(str);
        if (this.frequency == 0) {
            this.setWorkingEnabled(false);
        }
        if (this.frequency != 0) {
            this.addWirelessEnergy();
        }
    }

    public String getFrequencyString() {
        return Integer.valueOf(this.frequency).toString();
    }

    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (this.frequency == 0) {
            super.setWorkingEnabled(false);
            return;
        }
        super.setWorkingEnabled(isWorkingAllowed);
        if (this.frequency != 0) {
            if (isWorkingAllowed) {
                this.addWirelessEnergy();
            } else {
                this.removeWirelessEnergy();
            }
        }
        if (!isWorkingAllowed) {
            this.coolantTimer = 0;
        }
    }

    public void attachConfigurators(@NotNull ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new IFancyConfigurator(){

            public Component getTitle() {
                return Component.m_237115_((String)"gtmutils.gui.pterb.wireless_configurator.title");
            }

            public IGuiTexture getIcon() {
                return new ItemStackTexture(new Item[]{GTItems.SENSOR_UV.m_5456_()});
            }

            public Widget createConfigurator() {
                return new WidgetGroup(0, 0, 130, 25).addWidget((Widget)new TextFieldWidget().setNumbersOnly(0, Integer.MAX_VALUE).setTextResponder(PTERBMachine.this::setFrequencyFromString).setTextSupplier(PTERBMachine.this::getFrequencyString));
            }
        }});
    }

    @NotNull
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 190, 125);
        group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 182, 117).setBackground(this.getScreenTexture()).addWidget((Widget)new LabelWidget(4, 5, this.self().getBlockState().m_60734_().m_7705_())).addWidget((Widget)new ComponentPanelWidget(4, 17, this::addDisplayText).setMaxWidthLimit(150).clickHandler((arg_0, arg_1) -> ((PTERBMachine)this).handleDisplayClick(arg_0, arg_1))));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    @NotNull
    public ModularUI createUI(@NotNull Player entityPlayer) {
        return new ModularUI(198, 208, (IUIHolder)this, entityPlayer).widget((Widget)new FancyMachineUIWidget((IFancyUIProvider)this, 198, 208));
    }

    public int getCoolantDrain() {
        return this.coolantDrain;
    }

    public int getFrequency() {
        return this.frequency;
    }
}

