/*
 * Decompiled with CFR 0.152.
 */
package net.neganote.gtutilities.recipe;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.ResearchRecipeBuilder;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GTMultiMachines;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.GTCraftingComponents;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import net.neganote.gtutilities.common.item.UtilItems;
import net.neganote.gtutilities.common.machine.UtilMachines;
import net.neganote.gtutilities.config.UtilConfig;

public class UtilRecipes {
    public static void init(Consumer<FinishedRecipe> provider) {
        if (UtilConfig.INSTANCE.features.converters64aEnabled && ConfigHolder.INSTANCE.compat.energy.enableFEConverters) {
            UtilRecipes.register64AConverterRecipes(provider);
        }
        if (UtilConfig.INSTANCE.features.omnibreakerEnabled) {
            UtilRecipes.registerOmnitoolRecipe(provider);
        }
        if (UtilConfig.INSTANCE.features.pterbEnabled) {
            GTRecipeTypes.ASSEMBLY_LINE_RECIPES.recipeBuilder("pterb").inputItems((MachineDefinition)GTMultiMachines.ACTIVE_TRANSFORMER).inputItems(TagPrefix.plate, GTMaterials.Neutronium, 32).inputItems(GTCraftingComponents.SENSOR.get(8), 8).inputItems(GTCraftingComponents.EMITTER.get(8), 8).inputItems(GTCraftingComponents.FIELD_GENERATOR.get(8), 4).inputItems(CustomTags.UHV_CIRCUITS, 2).inputItems(TagPrefix.pipeLargeFluid, GTMaterials.Neutronium, 4).inputItems(GTCraftingComponents.CABLE_QUAD.get(8), 8).inputItems((Object)GTBlocks.LASER_PIPES[0], 8).inputFluids(GTMaterials.SolderingAlloy.getFluid(4608)).EUt(1600000L).duration(1200).outputItems((MachineDefinition)UtilMachines.PTERB_MACHINE).addMaterialInfo(true).stationResearch(b -> ((ResearchRecipeBuilder.StationRecipeBuilder)b.researchStack(GTMultiMachines.ACTIVE_TRANSFORMER.asStack())).CWUt(16)).save(provider);
        }
    }

    public static void register64AConverterRecipes(Consumer<FinishedRecipe> provider) {
        for (int tier : GTValues.tiersBetween((int)0, (int)(GTCEuAPI.isHighTier() ? 14 : 9))) {
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("converter_64a_" + GTValues.VN[tier]).inputItems(GTCraftingComponents.HULL.get(tier)).inputItems(GTCraftingComponents.CIRCUIT.get(tier)).inputItems(GTCraftingComponents.CABLE_HEX.get(0), 4).inputItems(GTCraftingComponents.CABLE_HEX.get(tier), 16).outputItems(UtilMachines.ENERGY_CONVERTER_64A[tier]).EUt((long)GTValues.VA[tier]).duration(40).addMaterialInfo(true).save(provider);
        }
    }

    private static ItemStack getPowerUnit(int tier) {
        return switch (tier) {
            case 1 -> GTItems.POWER_UNIT_LV.asStack();
            case 2 -> GTItems.POWER_UNIT_MV.asStack();
            case 3 -> GTItems.POWER_UNIT_HV.asStack();
            case 4 -> GTItems.POWER_UNIT_EV.asStack();
            case 5 -> GTItems.POWER_UNIT_IV.asStack();
            default -> GTItems.POWER_UNIT_LV.asStack();
        };
    }

    public static void registerOmnitoolRecipe(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("omnibreaker").inputItems(UtilRecipes.getPowerUnit(UtilConfig.INSTANCE.features.omnibreakerTier)).inputItems(GTCraftingComponents.CIRCUIT.get(UtilConfig.INSTANCE.features.omnibreakerTier), 2).inputItems(GTCraftingComponents.EMITTER.get(UtilConfig.INSTANCE.features.omnibreakerTier), 1).inputItems(GTCraftingComponents.CABLE_QUAD.get(UtilConfig.INSTANCE.features.omnibreakerTier), 3).inputItems(GTCraftingComponents.MOTOR.get(UtilConfig.INSTANCE.features.omnibreakerTier), 2).outputItems(UtilItems.OMNIBREAKER).EUt((long)GTValues.VA[UtilConfig.INSTANCE.features.omnibreakerTier], 2L).duration(1200).addMaterialInfo(true).save(provider);
    }
}

