/*
 * Decompiled with CFR 0.152.
 */
package net.neganote.gtutilities.common.tools.recipe;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neganote.gtutilities.common.item.UtilToolItems;
import net.neganote.gtutilities.common.tools.UtilToolType;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class UtilToolRecipeHelper {
    public static final Int2ReferenceMap<ItemEntry<? extends Item>> powerUnitItems = new Int2ReferenceArrayMap(GTValues.tiersBetween((int)1, (int)7), (Object[])new ItemEntry[]{GTItems.POWER_UNIT_LV, GTItems.POWER_UNIT_MV, GTItems.POWER_UNIT_HV, GTItems.POWER_UNIT_EV, GTItems.POWER_UNIT_IV, UtilToolItems.POWER_UNIT_LUV, UtilToolItems.POWER_UNIT_ZPM});

    private UtilToolRecipeHelper() {
    }

    public static void run(Consumer<FinishedRecipe> provider, Material material) {
        ToolProperty property = (ToolProperty)material.getProperty(PropertyKey.TOOL);
        if (property == null) {
            return;
        }
        UtilToolRecipeHelper.processElectricTool(provider, property, material);
    }

    private static void processElectricTool(Consumer<FinishedRecipe> provider, ToolProperty property, Material material) {
        TagPrefix toolPrefix;
        int voltageMultiplier;
        if (!material.shouldGenerateRecipesFor(TagPrefix.plate)) {
            return;
        }
        int n = voltageMultiplier = material.getBlastTemperature() > 2800 ? GTValues.VA[1] : GTValues.VA[0];
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            MaterialEntry plate = new MaterialEntry(TagPrefix.plate, material);
            MaterialEntry steelPlate = new MaterialEntry(TagPrefix.plate, GTMaterials.Steel);
            MaterialEntry steelRing = new MaterialEntry(TagPrefix.ring, GTMaterials.Steel);
            if (property.hasType(GTToolType.CHAINSAW_LV)) {
                toolPrefix = TagPrefix.toolHeadChainsaw;
                VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("chainsaw_head_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)toolPrefix, (Material)material), (Object[])new Object[]{"SRS", "XhX", "SRS", Character.valueOf('X'), plate, Character.valueOf('S'), steelPlate, Character.valueOf('R'), steelRing});
                UtilToolRecipeHelper.addElectricToolRecipe(provider, toolPrefix, new GTToolType[]{UtilToolType.CHAINSAW_MV, UtilToolType.CHAINSAW_HV, UtilToolType.CHAINSAW_EV, UtilToolType.CHAINSAW_IV, UtilToolType.CHAINSAW_LuV, UtilToolType.CHAINSAW_ZPM}, material);
            }
            if (property.hasType(GTToolType.DRILL_LV)) {
                toolPrefix = TagPrefix.toolHeadDrill;
                VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("drill_head_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)toolPrefix, (Material)material), (Object[])new Object[]{"XSX", "XSX", "ShS", Character.valueOf('X'), plate, Character.valueOf('S'), steelPlate});
                UtilToolRecipeHelper.addElectricToolRecipe(provider, toolPrefix, new GTToolType[]{UtilToolType.DRILL_LUV, UtilToolType.DRILL_ZPM}, material);
            }
            if (property.hasType(GTToolType.WIRE_CUTTER_LV)) {
                toolPrefix = TagPrefix.toolHeadWireCutter;
                UtilToolRecipeHelper.addElectricToolRecipe(provider, toolPrefix, new GTToolType[]{UtilToolType.WIRE_CUTTER_MV, UtilToolType.WIRE_CUTTER_EV, UtilToolType.WIRE_CUTTER_LuV, UtilToolType.WIRE_CUTTER_ZPM}, material);
                VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("wirecutter_head_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)toolPrefix, (Material)material), (Object[])new Object[]{"XfX", "X X", "SRS", Character.valueOf('X'), plate, Character.valueOf('R'), steelRing, Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Steel)});
            }
            if (property.hasType(GTToolType.BUZZSAW)) {
                toolPrefix = TagPrefix.toolHeadBuzzSaw;
                UtilToolRecipeHelper.addElectricToolRecipe(provider, toolPrefix, new GTToolType[]{UtilToolType.BUZZSAW_MV, UtilToolType.BUZZSAW_HV, UtilToolType.BUZZSAW_EV, UtilToolType.BUZZSAW_IV, UtilToolType.BUZZSAW_LuV, UtilToolType.BUZZSAW_ZPM}, material);
                VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("buzzsaw_blade_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)toolPrefix, (Material)material), (Object[])new Object[]{"sXh", "X X", "fXx", Character.valueOf('X'), plate});
            }
            if (property.hasType(GTToolType.WRENCH_LV)) {
                toolPrefix = TagPrefix.toolHeadWrench;
                UtilToolRecipeHelper.addElectricToolRecipe(provider, toolPrefix, new GTToolType[]{UtilToolType.WRENCH_MV, UtilToolType.WRENCH_EV, UtilToolType.WRENCH_LuV, UtilToolType.WRENCH_ZPM}, material);
                VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("wrench_head_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)toolPrefix, (Material)material), (Object[])new Object[]{"hXW", "XRX", "WXd", Character.valueOf('X'), plate, Character.valueOf('R'), steelRing, Character.valueOf('W'), new MaterialEntry(TagPrefix.screw, GTMaterials.Steel)});
            }
        }
        if (property.hasType(GTToolType.SCREWDRIVER_LV) && material.hasFlag(MaterialFlags.GENERATE_LONG_ROD)) {
            toolPrefix = TagPrefix.toolHeadScrewdriver;
            UtilToolRecipeHelper.addElectricToolRecipe(provider, toolPrefix, new GTToolType[]{UtilToolType.SCREWDRIVER_MV, UtilToolType.SCREWDRIVER_HV, UtilToolType.SCREWDRIVER_EV, UtilToolType.SCREWDRIVER_IV, UtilToolType.SCREWDRIVER_LuV, UtilToolType.SCREWDRIVER_ZPM}, material);
            VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("screwdriver_tip_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)toolPrefix, (Material)material), (Object[])new Object[]{"fR", " h", Character.valueOf('R'), new MaterialEntry(TagPrefix.rodLong, material)});
        }
    }

    private static void addElectricToolRecipe(Consumer<FinishedRecipe> provider, TagPrefix toolHead, GTToolType[] toolItems, Material material) {
        for (GTToolType toolType : toolItems) {
            if (!((ToolProperty)material.getProperty(PropertyKey.TOOL)).hasType(toolType)) continue;
            int tier = toolType.electricTier;
            ItemStack powerUnitStack = ((ItemEntry)powerUnitItems.get(tier)).asStack();
            IElectricItem powerUnit = GTCapabilityHelper.getElectricItem((ItemStack)powerUnitStack);
            ItemStack tool = ((IGTTool)((ItemProviderEntry)GTMaterialItems.TOOL_ITEMS.get((Object)material, (Object)toolType)).get()).get(0L, powerUnit.getMaxCharge());
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, (boolean)true, (boolean)true, (boolean)true, (String)String.format("%s_%s", material.getName(), toolType.name), (Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{powerUnitStack}), (ItemStack)tool, (Object[])new Object[]{"wHd", " U ", Character.valueOf('H'), new MaterialEntry(toolHead, material), Character.valueOf('U'), powerUnitStack});
        }
    }
}

