/*
 * Decompiled with CFR 0.152.
 */
package net.neganote.gtutilities.common.tools.recipe;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.utils.ToolItemHelper;
import com.tterrag.registrate.util.entry.ItemEntry;
import it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neganote.gtutilities.common.item.UtilToolItems;
import net.neganote.gtutilities.common.tools.recipe.UtilToolRecipeHelper;
import net.neganote.gtutilities.config.UtilConfig;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class UtilToolRecipes {
    private static final Int2ReferenceMap<ItemEntry<? extends Item>> motorItems = new Int2ReferenceArrayMap();
    private static final Int2ReferenceMap<Material> baseMaterials = new Int2ReferenceArrayMap();
    private static final Int2ReferenceMap<List<ItemEntry<? extends Item>>> batteryItems = new Int2ReferenceArrayMap();

    private UtilToolRecipes() {
    }

    public static void init(Consumer<FinishedRecipe> provider) {
        UtilToolRecipes.initTierMaps();
        UtilToolRecipes.registerPowerUnitRecipes(provider);
        for (Material material : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            UtilToolRecipeHelper.run(provider, material);
        }
    }

    private static void initTierMaps() {
        if (UtilConfig.INSTANCE.features.customLuVToolsEnabled) {
            motorItems.put(6, (Object)GTItems.ELECTRIC_MOTOR_LuV);
            baseMaterials.put(6, (Object)GTMaterials.RhodiumPlatedPalladium);
            batteryItems.put(6, List.of(GTItems.ENERGY_LAPOTRONIC_ORB_CLUSTER));
            UtilToolRecipeHelper.powerUnitItems.put(6, UtilToolItems.POWER_UNIT_LUV);
        }
        if (UtilConfig.INSTANCE.features.customZPMToolsEnabled) {
            motorItems.put(7, (Object)GTItems.ELECTRIC_MOTOR_ZPM);
            baseMaterials.put(7, (Object)GTMaterials.NaquadahAlloy);
            batteryItems.put(7, List.of(GTItems.ENERGY_MODULE));
            UtilToolRecipeHelper.powerUnitItems.put(7, UtilToolItems.POWER_UNIT_ZPM);
        }
    }

    private static void registerPowerUnitRecipes(Consumer<FinishedRecipe> provider) {
        IntIterator intIterator = UtilToolRecipeHelper.powerUnitItems.keySet().iterator();
        while (intIterator.hasNext()) {
            int tier = (Integer)intIterator.next();
            ItemEntry powerUnitEntry = (ItemEntry)UtilToolRecipeHelper.powerUnitItems.get(tier);
            ItemEntry motorEntry = (ItemEntry)motorItems.get(tier);
            Material material = (Material)baseMaterials.get(tier);
            List batteries = (List)batteryItems.get(tier);
            if (powerUnitEntry == null || motorEntry == null || material == null || batteries == null || batteries.isEmpty()) continue;
            for (ItemEntry batteryItem : batteries) {
                ItemStack batteryStack = batteryItem.asStack();
                long maxCharge = GTCapabilityHelper.getElectricItem((ItemStack)batteryStack).getMaxCharge();
                ItemStack powerUnitStack = ToolItemHelper.getMaxChargeOverrideStack((Item)((Item)powerUnitEntry.get()), (long)maxCharge);
                String recipeName = String.format("%s_%s", BuiltInRegistries.f_257033_.m_7981_((Object)((Item)powerUnitEntry.get())).m_135815_(), BuiltInRegistries.f_257033_.m_7981_((Object)((Item)batteryItem.get())).m_135815_());
                VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, (boolean)true, (boolean)false, (boolean)true, (String)recipeName, (Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{batteryStack}), (ItemStack)powerUnitStack, (Object[])new Object[]{"S d", "GMG", "PBP", Character.valueOf('M'), motorEntry.asStack(), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, material), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, material), Character.valueOf('B'), batteryStack});
            }
        }
    }
}

